/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateStorageService;
import org.openmetadata.client.model.DatabaseService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.StorageService;
import org.openmetadata.client.model.StorageServiceList;
import org.openmetadata.client.model.TestConnectionResult;

public interface ObjectStoreServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/storageServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseService4(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/storageServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseService4WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/storageServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService addTestConnectionResult10(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/storageServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> addTestConnectionResult10WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StorageService createOrUpdateStorageService(@Nullable CreateStorageService var1);

    @RequestLine(value="PUT /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StorageService> createOrUpdateStorageServiceWithHttpInfo(@Nullable CreateStorageService var1);

    @RequestLine(value="POST /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StorageService createStorageService(@Nullable CreateStorageService var1);

    @RequestLine(value="POST /v1/services/storageServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StorageService> createStorageServiceWithHttpInfo(@Nullable CreateStorageService var1);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower20(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower20WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageService(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageService(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteStorageServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/storageServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceWithHttpInfo(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteStorageServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/storageServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageServiceAsync(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageServiceAsync(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteStorageServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/storageServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteStorageServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageServiceByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStorageServiceByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteStorageServiceByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/storageServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStorageServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteStorageServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public StorageService getSpecificStorageServiceVersion(@Param(value="id") @Nonnull String var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getSpecificStorageServiceVersionWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetStorageServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/storageServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetStorageServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageService getStorageServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetStorageServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageService> getStorageServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetStorageServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllStorageServiceVersion(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/storageServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllStorageServiceVersionWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageServiceList listStorageServices(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageServiceList> listStorageServicesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StorageServiceList listStorageServices(@QueryMap(encoded=true) ListStorageServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/storageServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StorageServiceList> listStorageServicesWithHttpInfo(@QueryMap(encoded=true) ListStorageServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/storageServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchStorageService(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/storageServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchStorageServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/storageServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchStorageServiceByFQN(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/storageServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchStorageServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/storageServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StorageService restore36(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/storageServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StorageService> restore36WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListStorageServicesQueryParams
    extends HashMap<String, Object> {
        public ListStorageServicesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListStorageServicesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStorageServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetStorageServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStorageServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStorageServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetStorageServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStorageServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStorageServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteStorageServiceByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStorageServiceByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStorageServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteStorageServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStorageServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStorageServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteStorageServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStorageServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

