/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreatePersona;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Persona;
import org.openmetadata.client.model.PersonaList;

public interface PersonasApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Persona createOrUpdatePersona(@Nullable CreatePersona var1);

    @RequestLine(value="PUT /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Persona> createOrUpdatePersonaWithHttpInfo(@Nullable CreatePersona var1);

    @RequestLine(value="POST /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Persona createPersona(@Nullable CreatePersona var1);

    @RequestLine(value="POST /v1/personas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Persona> createPersonaWithHttpInfo(@Nullable CreatePersona var1);

    @RequestLine(value="DELETE /v1/personas/{id}")
    @Headers(value={"Accept: application/json"})
    public void deletePersona(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/personas/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePersonaWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/personas/async/{id}")
    @Headers(value={"Accept: application/json"})
    public void deletePersonaAsync(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/personas/async/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePersonaAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/personas/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deletePersonaByName(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/personas/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePersonaByNameWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetPersonaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/personas/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetPersonaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Persona getPersonaByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPersonaByIDQueryParams var2);

    @RequestLine(value="GET /v1/personas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getPersonaByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPersonaByIDQueryParams var2);

    @RequestLine(value="GET /v1/personas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Persona getSpecificPersonaVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/personas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Persona> getSpecificPersonaVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/personas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPersonaVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/personas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPersonaVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public PersonaList listPersonas(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonaList> listPersonasWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public PersonaList listPersonas(@QueryMap(encoded=true) ListPersonasQueryParams var1);

    @RequestLine(value="GET /v1/personas?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PersonaList> listPersonasWithHttpInfo(@QueryMap(encoded=true) ListPersonasQueryParams var1);

    @RequestLine(value="PATCH /v1/personas/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPersona(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/personas/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPersonaWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/personas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPersona1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/personas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPersona1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    public static class ListPersonasQueryParams
    extends HashMap<String, Object> {
        public ListPersonasQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPersonasQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPersonasQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPersonasQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPersonaByIDQueryParams
    extends HashMap<String, Object> {
        public GetPersonaByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPersonaByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPersonaByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPersonaByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPersonaByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }
}

