/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreatePipelineService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.PipelineService;
import org.openmetadata.client.model.PipelineServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface PipelineServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/pipelineServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseService2(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/pipelineServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseService2WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/pipelineServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService addTestConnectionResult7(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/pipelineServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> addTestConnectionResult7WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService createOrUpdatePipelineService(@Nullable CreatePipelineService var1);

    @RequestLine(value="PUT /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> createOrUpdatePipelineServiceWithHttpInfo(@Nullable CreatePipelineService var1);

    @RequestLine(value="POST /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService createPipelineService(@Nullable CreatePipelineService var1);

    @RequestLine(value="POST /v1/services/pipelineServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> createPipelineServiceWithHttpInfo(@Nullable CreatePipelineService var1);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower17(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower17WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePipelineServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineServiceByName(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePipelineServiceByName(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeletePipelineServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/pipelineServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePipelineServiceByNameWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeletePipelineServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetPipelineServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetPipelineServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getPipelineServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPipelineServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getPipelineServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPipelineServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public PipelineService getSpecificPipelineService(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineService> getSpecificPipelineServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPipelineServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/pipelineServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPipelineServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceList listPipelineService(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceList> listPipelineServiceWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceList listPipelineService(@QueryMap(encoded=true) ListPipelineServiceQueryParams var1);

    @RequestLine(value="GET /v1/services/pipelineServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceList> listPipelineServiceWithHttpInfo(@QueryMap(encoded=true) ListPipelineServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/services/pipelineServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipelineService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/pipelineServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPipelineServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/pipelineServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipelineService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/pipelineServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPipelineService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/pipelineServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineService restore33(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/pipelineServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineService> restore33WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListPipelineServiceQueryParams
    extends HashMap<String, Object> {
        public ListPipelineServiceQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineServiceQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetPipelineServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPipelineServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineServiceQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeletePipelineServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

