/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreatePolicy;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Policy;
import org.openmetadata.client.model.PolicyList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.ResultListFunction;
import org.openmetadata.client.model.ResultListResourceDescriptor;

public interface PoliciesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/policies")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Policy createOrUpdatePolicy(@Nullable CreatePolicy var1);

    @RequestLine(value="PUT /v1/policies")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Policy> createOrUpdatePolicyWithHttpInfo(@Nullable CreatePolicy var1);

    @RequestLine(value="POST /v1/policies")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Policy createPolicy(@Nullable CreatePolicy var1);

    @RequestLine(value="POST /v1/policies")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Policy> createPolicyWithHttpInfo(@Nullable CreatePolicy var1);

    @RequestLine(value="DELETE /v1/policies/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePolicy(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/policies/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePolicyWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/policies/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePolicy(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePolicyQueryParams var2);

    @RequestLine(value="DELETE /v1/policies/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePolicyWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePolicyQueryParams var2);

    @RequestLine(value="DELETE /v1/policies/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePolicyAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/policies/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePolicyAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/policies/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePolicyAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePolicyAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/policies/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePolicyAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeletePolicyAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/policies/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePolicyByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/policies/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePolicyByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/policies/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deletePolicyByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeletePolicyByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/policies/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePolicyByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeletePolicyByFQNQueryParams var2);

    @RequestLine(value="GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Policy getPolicyByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Policy> getPolicyByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Policy getPolicyByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetPolicyByFQNQueryParams var2);

    @RequestLine(value="GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Policy> getPolicyByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetPolicyByFQNQueryParams var2);

    @RequestLine(value="GET /v1/policies/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Policy getPolicyByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/policies/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Policy> getPolicyByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/policies/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Policy getPolicyByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPolicyByIDQueryParams var2);

    @RequestLine(value="GET /v1/policies/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Policy> getPolicyByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetPolicyByIDQueryParams var2);

    @RequestLine(value="GET /v1/policies/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Policy getSpecificPolicyVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/policies/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Policy> getSpecificPolicyVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/policies/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPolicyVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/policies/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllPolicyVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PolicyList listPolicies(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PolicyList> listPoliciesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PolicyList listPolicies(@QueryMap(encoded=true) ListPoliciesQueryParams var1);

    @RequestLine(value="GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PolicyList> listPoliciesWithHttpInfo(@QueryMap(encoded=true) ListPoliciesQueryParams var1);

    @RequestLine(value="GET /v1/policies/functions")
    @Headers(value={"Accept: application/json"})
    public ResultListFunction listPolicyFunctions();

    @RequestLine(value="GET /v1/policies/functions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResultListFunction> listPolicyFunctionsWithHttpInfo();

    @RequestLine(value="GET /v1/policies/resources")
    @Headers(value={"Accept: application/json"})
    public ResultListResourceDescriptor listPolicyResources();

    @RequestLine(value="GET /v1/policies/resources")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResultListResourceDescriptor> listPolicyResourcesWithHttpInfo();

    @RequestLine(value="PATCH /v1/policies/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPolicy(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/policies/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPolicyWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/policies/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPolicy1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/policies/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPolicy1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/policies/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Policy restore22(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/policies/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Policy> restore22WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="GET /v1/policies/validation/condition/{expression}")
    @Headers(value={"Accept: application/json"})
    public void validateCondition(@Param(value="expression") @Nonnull String var1);

    @RequestLine(value="GET /v1/policies/validation/condition/{expression}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> validateConditionWithHttpInfo(@Param(value="expression") @Nonnull String var1);

    public static class ListPoliciesQueryParams
    extends HashMap<String, Object> {
        public ListPoliciesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPolicyByIDQueryParams
    extends HashMap<String, Object> {
        public GetPolicyByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPolicyByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPolicyByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPolicyByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPolicyByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePolicyByFQNQueryParams
    extends HashMap<String, Object> {
        public DeletePolicyByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePolicyAsyncQueryParams
    extends HashMap<String, Object> {
        public DeletePolicyAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePolicyQueryParams
    extends HashMap<String, Object> {
        public DeletePolicyQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

