/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateSearchService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchService;
import org.openmetadata.client.model.SearchServiceList;
import org.openmetadata.client.model.TestConnectionResult;

public interface SearchServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/searchServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseService3(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/searchServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseService3WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/searchServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService addTestConnectionResult8(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/searchServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> addTestConnectionResult8WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService createOrUpdateSearchService(@Nullable CreateSearchService var1);

    @RequestLine(value="PUT /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> createOrUpdateSearchServiceWithHttpInfo(@Nullable CreateSearchService var1);

    @RequestLine(value="POST /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService createSearchService(@Nullable CreateSearchService var1);

    @RequestLine(value="POST /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> createSearchServiceWithHttpInfo(@Nullable CreateSearchService var1);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower18(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower18WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchService(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchService(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceWithHttpInfo(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchServiceAsync(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchServiceAsync(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchServiceByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchServiceByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchServiceByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteSearchServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetSearchServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetSearchServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSearchServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSearchServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSpecificSearchServiceVersion(@Param(value="id") @Nonnull String var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSpecificSearchServiceVersionWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllSearchServiceVersion(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllSearchServiceVersionWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchServiceList listSearchServices(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchServiceList> listSearchServicesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchServiceList listSearchServices(@QueryMap(encoded=true) ListSearchServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchServiceList> listSearchServicesWithHttpInfo(@QueryMap(encoded=true) ListSearchServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/searchServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/searchServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/searchServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/searchServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/searchServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService restore34(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/searchServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> restore34WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListSearchServicesQueryParams
    extends HashMap<String, Object> {
        public ListSearchServicesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSearchServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetSearchServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSearchServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSearchServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSearchServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSearchServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchServiceByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchServiceByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

