/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateSecurityService;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SecurityService;
import org.openmetadata.client.model.SecurityServiceList;
import org.openmetadata.client.model.TestConnectionResult;

public interface SecurityServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/securityServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToSecurityService(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/securityServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToSecurityServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/securityServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SecurityService addTestConnectionResult9(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/securityServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SecurityService> addTestConnectionResult9WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/securityServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SecurityService createOrUpdateSecurityService(@Nullable CreateSecurityService var1);

    @RequestLine(value="PUT /v1/services/securityServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SecurityService> createOrUpdateSecurityServiceWithHttpInfo(@Nullable CreateSecurityService var1);

    @RequestLine(value="POST /v1/services/securityServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SecurityService createSecurityService(@Nullable CreateSecurityService var1);

    @RequestLine(value="POST /v1/services/securityServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SecurityService> createSecurityServiceWithHttpInfo(@Nullable CreateSecurityService var1);

    @RequestLine(value="DELETE /v1/services/securityServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower19(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/securityServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower19WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/securityServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSecurityService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/securityServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSecurityServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/securityServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSecurityService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSecurityServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/securityServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSecurityServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSecurityServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/securityServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSecurityServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/securityServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSecurityServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/securityServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSecurityServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSecurityServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/securityServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSecurityServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSecurityServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/securityServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSecurityServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/securityServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSecurityServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/securityServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSecurityServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteSecurityServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/securityServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSecurityServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteSecurityServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportSecurityService(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportSecurityServiceWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public String exportSecurityServices(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportSecurityServicesWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SecurityService getSecurityServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityService> getSecurityServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SecurityService getSecurityServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetSecurityServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/securityServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityService> getSecurityServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetSecurityServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/securityServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SecurityService getSecurityServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/securityServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityService> getSecurityServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/securityServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SecurityService getSecurityServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSecurityServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/securityServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityService> getSecurityServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSecurityServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/securityServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public SecurityService getSpecificSecurityServiceVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/securityServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityService> getSpecificSecurityServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importSecurityService(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importSecurityServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importSecurityService(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportSecurityServiceQueryParams var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importSecurityServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportSecurityServiceQueryParams var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importSecurityServiceAsync(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importSecurityServiceAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importSecurityServiceAsync(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportSecurityServiceAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/services/securityServices/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importSecurityServiceAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportSecurityServiceAsyncQueryParams var3);

    @RequestLine(value="GET /v1/services/securityServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllSecurityServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/securityServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllSecurityServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/securityServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SecurityServiceList listSecurityServices(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/securityServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityServiceList> listSecurityServicesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/securityServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SecurityServiceList listSecurityServices(@QueryMap(encoded=true) ListSecurityServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/securityServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SecurityServiceList> listSecurityServicesWithHttpInfo(@QueryMap(encoded=true) ListSecurityServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/securityServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSecurityService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/securityServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSecurityServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/securityServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSecurityService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/securityServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSecurityService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/securityServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SecurityService restore35(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/securityServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SecurityService> restore35WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListSecurityServicesQueryParams
    extends HashMap<String, Object> {
        public ListSecurityServicesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListSecurityServicesQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListSecurityServicesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSecurityServicesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSecurityServicesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSecurityServicesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportSecurityServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportSecurityServiceAsyncQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportSecurityServiceQueryParams
    extends HashMap<String, Object> {
        public ImportSecurityServiceQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSecurityServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetSecurityServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSecurityServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSecurityServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSecurityServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSecurityServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSecurityServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteSecurityServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSecurityServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSecurityServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteSecurityServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSecurityServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSecurityServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteSecurityServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSecurityServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

