/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateSpreadsheet;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Spreadsheet;
import org.openmetadata.client.model.SpreadsheetList;
import org.openmetadata.client.model.VoteRequest;

public interface SpreadsheetsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/drives/spreadsheets/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToSpreadsheet(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/drives/spreadsheets/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToSpreadsheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/drives/spreadsheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Spreadsheet createOrUpdateSpreadsheet(@Nullable CreateSpreadsheet var1);

    @RequestLine(value="PUT /v1/drives/spreadsheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Spreadsheet> createOrUpdateSpreadsheetWithHttpInfo(@Nullable CreateSpreadsheet var1);

    @RequestLine(value="POST /v1/drives/spreadsheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Spreadsheet createSpreadsheet(@Nullable CreateSpreadsheet var1);

    @RequestLine(value="POST /v1/drives/spreadsheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Spreadsheet> createSpreadsheetWithHttpInfo(@Nullable CreateSpreadsheet var1);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSpreadsheet(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSpreadsheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSpreadsheet(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSpreadsheetQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSpreadsheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSpreadsheetQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSpreadsheetAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSpreadsheetAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSpreadsheetAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSpreadsheetAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSpreadsheetAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteSpreadsheetAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSpreadsheetByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSpreadsheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteSpreadsheetByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteSpreadsheetByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSpreadsheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteSpreadsheetByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Spreadsheet getSpecificSpreadsheetVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Spreadsheet> getSpecificSpreadsheetVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Spreadsheet getSpreadsheetByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/spreadsheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Spreadsheet> getSpreadsheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/spreadsheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Spreadsheet getSpreadsheetByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetSpreadsheetByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Spreadsheet> getSpreadsheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetSpreadsheetByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Spreadsheet getSpreadsheetByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Spreadsheet> getSpreadsheetByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Spreadsheet getSpreadsheetByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSpreadsheetByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Spreadsheet> getSpreadsheetByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSpreadsheetByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllSpreadsheetVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/spreadsheets/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllSpreadsheetVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/spreadsheets?fields={fields}&service={service}&directory={directory}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SpreadsheetList listSpreadsheets(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="directory") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/drives/spreadsheets?fields={fields}&service={service}&directory={directory}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SpreadsheetList> listSpreadsheetsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="directory") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/drives/spreadsheets?fields={fields}&service={service}&directory={directory}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SpreadsheetList listSpreadsheets(@QueryMap(encoded=true) ListSpreadsheetsQueryParams var1);

    @RequestLine(value="GET /v1/drives/spreadsheets?fields={fields}&service={service}&directory={directory}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SpreadsheetList> listSpreadsheetsWithHttpInfo(@QueryMap(encoded=true) ListSpreadsheetsQueryParams var1);

    @RequestLine(value="PATCH /v1/drives/spreadsheets/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSpreadsheet(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/drives/spreadsheets/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSpreadsheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent removeFollowerFromSpreadsheet(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/drives/spreadsheets/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> removeFollowerFromSpreadsheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="PUT /v1/drives/spreadsheets/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Spreadsheet restoreSpreadsheet(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/spreadsheets/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Spreadsheet> restoreSpreadsheetWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/spreadsheets/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForSpreadsheet(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/drives/spreadsheets/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForSpreadsheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListSpreadsheetsQueryParams
    extends HashMap<String, Object> {
        public ListSpreadsheetsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListSpreadsheetsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListSpreadsheetsQueryParams directory(@Nullable String value) {
            this.put("directory", EncodingUtils.encode(value));
            return this;
        }

        public ListSpreadsheetsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSpreadsheetsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSpreadsheetsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSpreadsheetsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSpreadsheetByIDQueryParams
    extends HashMap<String, Object> {
        public GetSpreadsheetByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSpreadsheetByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSpreadsheetByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSpreadsheetByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSpreadsheetByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSpreadsheetByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteSpreadsheetByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSpreadsheetByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSpreadsheetAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteSpreadsheetAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSpreadsheetAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSpreadsheetQueryParams
    extends HashMap<String, Object> {
        public DeleteSpreadsheetQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSpreadsheetQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

