/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateStoredProcedure;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.StoredProcedure;
import org.openmetadata.client.model.StoredProcedureList;
import org.openmetadata.client.model.VoteRequest;

public interface StoredProceduresApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/storedProcedures/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower1(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/storedProcedures/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StoredProcedure createOrUpdateStoredProcedure(@Nullable CreateStoredProcedure var1);

    @RequestLine(value="PUT /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StoredProcedure> createOrUpdateStoredProcedureWithHttpInfo(@Nullable CreateStoredProcedure var1);

    @RequestLine(value="POST /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StoredProcedure createStoredProcedure(@Nullable CreateStoredProcedure var1);

    @RequestLine(value="POST /v1/storedProcedures")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StoredProcedure> createStoredProcedureWithHttpInfo(@Nullable CreateStoredProcedure var1);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN1(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQN1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN1(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDBSchemaByFQN1QueryParams var2);

    @RequestLine(value="DELETE /v1/storedProcedures/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQN1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDBSchemaByFQN1QueryParams var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower3(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower3WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStoredProcedure(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStoredProcedureWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStoredProcedure(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteStoredProcedureQueryParams var2);

    @RequestLine(value="DELETE /v1/storedProcedures/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStoredProcedureWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteStoredProcedureQueryParams var2);

    @RequestLine(value="DELETE /v1/storedProcedures/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStoredProcedureAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStoredProcedureAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/storedProcedures/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteStoredProcedureAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteStoredProcedureAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/storedProcedures/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteStoredProcedureAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteStoredProcedureAsyncQueryParams var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getSpecificStoredProcedureVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getSpecificStoredProcedureVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetStoredProcedureByFQNQueryParams var2);

    @RequestLine(value="GET /v1/storedProcedures/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetStoredProcedureByFQNQueryParams var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedure getStoredProcedureByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetStoredProcedureByIDQueryParams var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedure> getStoredProcedureByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetStoredProcedureByIDQueryParams var2);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllStoredProceduresVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/storedProcedures/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllStoredProceduresVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedureList listStoredProcedures(@Param(value="fields") @Nullable String var1, @Param(value="databaseSchema") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedureList> listStoredProceduresWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="databaseSchema") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public StoredProcedureList listStoredProcedures(@QueryMap(encoded=true) ListStoredProceduresQueryParams var1);

    @RequestLine(value="GET /v1/storedProcedures?fields={fields}&databaseSchema={databaseSchema}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StoredProcedureList> listStoredProceduresWithHttpInfo(@QueryMap(encoded=true) ListStoredProceduresQueryParams var1);

    @RequestLine(value="PATCH /v1/storedProcedures/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchStoredProcedure(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/storedProcedures/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchStoredProcedureWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/storedProcedures/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchStoredProcedure1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/storedProcedures/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchStoredProcedure1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/storedProcedures/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StoredProcedure restore10(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/storedProcedures/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StoredProcedure> restore10WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/storedProcedures/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity4(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/storedProcedures/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity4WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListStoredProceduresQueryParams
    extends HashMap<String, Object> {
        public ListStoredProceduresQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams databaseSchema(@Nullable String value) {
            this.put("databaseSchema", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListStoredProceduresQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStoredProcedureByIDQueryParams
    extends HashMap<String, Object> {
        public GetStoredProcedureByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStoredProcedureByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetStoredProcedureByFQNQueryParams
    extends HashMap<String, Object> {
        public GetStoredProcedureByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetStoredProcedureByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStoredProcedureAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteStoredProcedureAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStoredProcedureAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteStoredProcedureQueryParams
    extends HashMap<String, Object> {
        public DeleteStoredProcedureQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteStoredProcedureQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaByFQN1QueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaByFQN1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaByFQN1QueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

