/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateSuggestion;
import org.openmetadata.client.model.Suggestion;
import org.openmetadata.client.model.SuggestionList;

public interface SuggestionsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/suggestions/accept-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public Suggestion acceptAllSuggestion(@Param(value="userId") @Nullable String var1, @Param(value="entityFQN") @Nullable String var2, @Param(value="suggestionType") @Nullable String var3);

    @RequestLine(value="PUT /v1/suggestions/accept-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> acceptAllSuggestionWithHttpInfo(@Param(value="userId") @Nullable String var1, @Param(value="entityFQN") @Nullable String var2, @Param(value="suggestionType") @Nullable String var3);

    @RequestLine(value="PUT /v1/suggestions/accept-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public Suggestion acceptAllSuggestion(@QueryMap(encoded=true) AcceptAllSuggestionQueryParams var1);

    @RequestLine(value="PUT /v1/suggestions/accept-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> acceptAllSuggestionWithHttpInfo(@QueryMap(encoded=true) AcceptAllSuggestionQueryParams var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/accept")
    @Headers(value={"Accept: application/json"})
    public Suggestion acceptSuggestion(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/accept")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> acceptSuggestionWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="POST /v1/suggestions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Suggestion createSuggestion(@Nullable CreateSuggestion var1);

    @RequestLine(value="POST /v1/suggestions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Suggestion> createSuggestionWithHttpInfo(@Nullable CreateSuggestion var1);

    @RequestLine(value="DELETE /v1/suggestions/{suggestionId}")
    @Headers(value={"Accept: application/json"})
    public void deleteSuggestion(@Param(value="suggestionId") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/suggestions/{suggestionId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSuggestionWithHttpInfo(@Param(value="suggestionId") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/suggestions/{entityType}/name/{entityFQN}")
    @Headers(value={"Accept: application/json"})
    public void deleteSuggestions(@Param(value="entityType") @Nonnull String var1, @Param(value="entityFQN") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/suggestions/{entityType}/name/{entityFQN}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSuggestionsWithHttpInfo(@Param(value="entityType") @Nonnull String var1, @Param(value="entityFQN") @Nonnull String var2);

    @RequestLine(value="GET /v1/suggestions/{id}")
    @Headers(value={"Accept: application/json"})
    public Suggestion getSuggestionByID(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/suggestions/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> getSuggestionByIDWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public SuggestionList listSuggestions(@Param(value="limit") @Nullable Integer var1, @Param(value="before") @Nullable String var2, @Param(value="after") @Nullable String var3, @Param(value="entityFQN") @Nullable String var4, @Param(value="userId") @Nullable String var5, @Param(value="status") @Nullable String var6);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SuggestionList> listSuggestionsWithHttpInfo(@Param(value="limit") @Nullable Integer var1, @Param(value="before") @Nullable String var2, @Param(value="after") @Nullable String var3, @Param(value="entityFQN") @Nullable String var4, @Param(value="userId") @Nullable String var5, @Param(value="status") @Nullable String var6);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public SuggestionList listSuggestions(@QueryMap(encoded=true) ListSuggestionsQueryParams var1);

    @RequestLine(value="GET /v1/suggestions?limit={limit}&before={before}&after={after}&entityFQN={entityFQN}&userId={userId}&status={status}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SuggestionList> listSuggestionsWithHttpInfo(@QueryMap(encoded=true) ListSuggestionsQueryParams var1);

    @RequestLine(value="PUT /v1/suggestions/reject-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public Suggestion rejectAllSuggestion(@Param(value="userId") @Nullable String var1, @Param(value="entityFQN") @Nullable String var2, @Param(value="suggestionType") @Nullable String var3);

    @RequestLine(value="PUT /v1/suggestions/reject-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> rejectAllSuggestionWithHttpInfo(@Param(value="userId") @Nullable String var1, @Param(value="entityFQN") @Nullable String var2, @Param(value="suggestionType") @Nullable String var3);

    @RequestLine(value="PUT /v1/suggestions/reject-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public Suggestion rejectAllSuggestion(@QueryMap(encoded=true) RejectAllSuggestionQueryParams var1);

    @RequestLine(value="PUT /v1/suggestions/reject-all?userId={userId}&entityFQN={entityFQN}&suggestionType={suggestionType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> rejectAllSuggestionWithHttpInfo(@QueryMap(encoded=true) RejectAllSuggestionQueryParams var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/reject")
    @Headers(value={"Accept: application/json"})
    public Suggestion rejectSuggestion(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="PUT /v1/suggestions/{id}/reject")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggestion> rejectSuggestionWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="PUT /v1/suggestions/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateSuggestion(@Param(value="id") @Nonnull String var1, @Nullable Suggestion var2);

    @RequestLine(value="PUT /v1/suggestions/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateSuggestionWithHttpInfo(@Param(value="id") @Nonnull String var1, @Nullable Suggestion var2);

    public static class RejectAllSuggestionQueryParams
    extends HashMap<String, Object> {
        public RejectAllSuggestionQueryParams userId(@Nullable String value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public RejectAllSuggestionQueryParams entityFQN(@Nullable String value) {
            this.put("entityFQN", EncodingUtils.encode(value));
            return this;
        }

        public RejectAllSuggestionQueryParams suggestionType(@Nullable String value) {
            this.put("suggestionType", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListSuggestionsQueryParams
    extends HashMap<String, Object> {
        public ListSuggestionsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams entityFQN(@Nullable String value) {
            this.put("entityFQN", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams userId(@Nullable String value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public ListSuggestionsQueryParams status(@Nullable String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class AcceptAllSuggestionQueryParams
    extends HashMap<String, Object> {
        public AcceptAllSuggestionQueryParams userId(@Nullable String value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public AcceptAllSuggestionQueryParams entityFQN(@Nullable String value) {
            this.put("entityFQN", EncodingUtils.encode(value));
            return this;
        }

        public AcceptAllSuggestionQueryParams suggestionType(@Nullable String value) {
            this.put("suggestionType", EncodingUtils.encode(value));
            return this;
        }
    }
}

