/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.ColumnProfileList;
import org.openmetadata.client.model.CreateCustomMetric;
import org.openmetadata.client.model.CreateTable;
import org.openmetadata.client.model.CreateTableProfile;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.DataModel;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchEntityRelationshipResult;
import org.openmetadata.client.model.SystemProfileList;
import org.openmetadata.client.model.Table;
import org.openmetadata.client.model.TableColumnList;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TableJoins;
import org.openmetadata.client.model.TableList;
import org.openmetadata.client.model.TableProfile;
import org.openmetadata.client.model.TableProfileList;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.VoteRequest;

public interface TablesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/tables/{id}/customMetric")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addCustomMetric(@Param(value="id") @Nonnull UUID var1, @Nullable CreateCustomMetric var2);

    @RequestLine(value="PUT /v1/tables/{id}/customMetric")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addCustomMetricWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable CreateCustomMetric var2);

    @RequestLine(value="PUT /v1/tables/{id}/dataModel")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataModel(@Param(value="id") @Nonnull String var1, @Nullable DataModel var2);

    @RequestLine(value="PUT /v1/tables/{id}/dataModel")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addDataModelWithHttpInfo(@Param(value="id") @Nonnull String var1, @Nullable DataModel var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataProfiler(@Param(value="id") @Nonnull UUID var1, @Nullable CreateTableProfile var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addDataProfilerWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable CreateTableProfile var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataProfilerConfig2(@Param(value="id") @Nonnull UUID var1, @Nullable TableProfilerConfig var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addDataProfilerConfig2WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TableProfilerConfig var2);

    @RequestLine(value="PUT /v1/tables/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToTable(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/tables/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToTableWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/tables/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addSampleData(@Param(value="id") @Nonnull UUID var1, @Nullable TableData var2);

    @RequestLine(value="PUT /v1/tables/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addSampleDataWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TableData var2);

    @RequestLine(value="PUT /v1/tables/{id}/joins")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addTableJoinInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TableJoins var2);

    @RequestLine(value="PUT /v1/tables/{id}/joins")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> addTableJoinInfoWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TableJoins var2);

    @RequestLine(value="PUT /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table createOrUpdateTable(@Nullable CreateTable var1);

    @RequestLine(value="PUT /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> createOrUpdateTableWithHttpInfo(@Nullable CreateTable var1);

    @RequestLine(value="POST /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table createTable(@Nullable CreateTable var1);

    @RequestLine(value="POST /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> createTableWithHttpInfo(@Nullable CreateTable var1);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{columnName}/{customMetricName}")
    @Headers(value={"Accept: application/json"})
    public Table deleteCustomMetric(@Param(value="id") @Nonnull UUID var1, @Param(value="columnName") @Nonnull String var2, @Param(value="customMetricName") @Nonnull String var3);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{columnName}/{customMetricName}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteCustomMetricWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="columnName") @Nonnull String var2, @Param(value="customMetricName") @Nonnull String var3);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{customMetricName}")
    @Headers(value={"Accept: application/json"})
    public Table deleteCustomMetric1(@Param(value="id") @Nonnull UUID var1, @Param(value="customMetricName") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{customMetricName}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteCustomMetric1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="customMetricName") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/tables/{fqn}/{entityType}/{timestamp}/profile")
    @Headers(value={"Accept: application/json"})
    public TableProfile deleteDataProfiler(@Param(value="fqn") @Nonnull String var1, @Param(value="entityType") @Nonnull String var2, @Param(value="timestamp") @Nonnull Long var3);

    @RequestLine(value="DELETE /v1/tables/{fqn}/{entityType}/{timestamp}/profile")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableProfile> deleteDataProfilerWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="entityType") @Nonnull String var2, @Param(value="timestamp") @Nonnull Long var3);

    @RequestLine(value="DELETE /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public Table deleteDataProfilerConfig2(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteDataProfilerConfig2WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower4(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/tables/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower4WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public Table deleteSampleData(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> deleteSampleDataWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTableWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTableQueryParams var2);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTableWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTableQueryParams var2);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable1(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTable1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTable1(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteTable1QueryParams var2);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTable1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteTable1QueryParams var2);

    @RequestLine(value="DELETE /v1/tables/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTableAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tables/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTableAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/tables/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTableAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTableAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/tables/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTableAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTableAsyncQueryParams var2);

    @RequestLine(value="GET /v1/tables/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public String exportTable(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/tables/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportTableWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/tables/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public String exportTable1(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/tables/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportTable1WithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public Table getDataProfilerConfig2(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/tableProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getDataProfilerConfig2WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public Table getSampleData(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getSampleDataWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/tables/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Table getSpecificDatabaseVersion1(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/tables/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getSpecificDatabaseVersion1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTableByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTableByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTableByIDQueryParams var2);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTableByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTableByIDQueryParams var2);

    @RequestLine(value="GET /v1/tables/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList getTableColumns(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/tables/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> getTableColumnsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/tables/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList getTableColumns(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTableColumnsQueryParams var2);

    @RequestLine(value="GET /v1/tables/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> getTableColumnsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTableColumnsQueryParams var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList getTableColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> getTableColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList getTableColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTableColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> getTableColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTableColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile/latest?includeColumnProfile={includeColumnProfile}")
    @Headers(value={"Accept: application/json"})
    public Table getTheLatestTableAndColumnProfile(@Param(value="fqn") @Nonnull String var1, @Param(value="includeColumnProfile") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile/latest?includeColumnProfile={includeColumnProfile}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTheLatestTableAndColumnProfileWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="includeColumnProfile") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile/latest?includeColumnProfile={includeColumnProfile}")
    @Headers(value={"Accept: application/json"})
    public Table getTheLatestTableAndColumnProfile(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTheLatestTableAndColumnProfileQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile/latest?includeColumnProfile={includeColumnProfile}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Table> getTheLatestTableAndColumnProfileWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTheLatestTableAndColumnProfileQueryParams var2);

    @RequestLine(value="PUT /v1/tables/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTable(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTableWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTable(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTableQueryParams var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTableWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTableQueryParams var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTableAsync(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTableAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTableAsync(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTableAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/tables/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTableAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTableAsyncQueryParams var3);

    @RequestLine(value="GET /v1/tables/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTableVersion(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/tables/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTableVersionWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ColumnProfileList listColumnProfiles(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nonnull BigDecimal var2, @Param(value="endTs") @Nonnull BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ColumnProfileList> listColumnProfilesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nonnull BigDecimal var2, @Param(value="endTs") @Nonnull BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ColumnProfileList listColumnProfiles(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListColumnProfilesQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/columnProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ColumnProfileList> listColumnProfilesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListColumnProfilesQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TableProfileList listProfiles(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nullable BigDecimal var2, @Param(value="endTs") @Nullable BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableProfileList> listProfilesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nullable BigDecimal var2, @Param(value="endTs") @Nullable BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TableProfileList listProfiles(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListProfilesQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/tableProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableProfileList> listProfilesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListProfilesQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public SystemProfileList listSystemProfiles(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nonnull BigDecimal var2, @Param(value="endTs") @Nonnull BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SystemProfileList> listSystemProfilesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="startTs") @Nonnull BigDecimal var2, @Param(value="endTs") @Nonnull BigDecimal var3);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public SystemProfileList listSystemProfiles(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListSystemProfilesQueryParams var2);

    @RequestLine(value="GET /v1/tables/{fqn}/systemProfile?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SystemProfileList> listSystemProfilesWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) ListSystemProfilesQueryParams var2);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableList listTables(@Param(value="fields") @Nullable String var1, @Param(value="database") @Nullable String var2, @Param(value="databaseSchema") @Nullable String var3, @Param(value="includeEmptyTestSuite") @Nullable Boolean var4, @Param(value="limit") @Nullable Integer var5, @Param(value="before") @Nullable String var6, @Param(value="after") @Nullable String var7, @Param(value="include") @Nullable String var8);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableList> listTablesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="database") @Nullable String var2, @Param(value="databaseSchema") @Nullable String var3, @Param(value="includeEmptyTestSuite") @Nullable Boolean var4, @Param(value="limit") @Nullable Integer var5, @Param(value="before") @Nullable String var6, @Param(value="after") @Nullable String var7, @Param(value="include") @Nullable String var8);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableList listTables(@QueryMap(encoded=true) ListTablesQueryParams var1);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&databaseSchema={databaseSchema}&includeEmptyTestSuite={includeEmptyTestSuite}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableList> listTablesWithHttpInfo(@QueryMap(encoded=true) ListTablesQueryParams var1);

    @RequestLine(value="PATCH /v1/tables/name/{fqn}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTable(@Param(value="fqn") @Nonnull String var1, @Param(value="changeSource") @Nullable String var2, @Nullable Object var3);

    @RequestLine(value="PATCH /v1/tables/name/{fqn}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTableWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="changeSource") @Nullable String var2, @Nullable Object var3);

    @RequestLine(value="PATCH /v1/tables/name/{fqn}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTable(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2, @QueryMap(encoded=true) PatchTableQueryParams var3);

    @RequestLine(value="PATCH /v1/tables/name/{fqn}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTableWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2, @QueryMap(encoded=true) PatchTableQueryParams var3);

    @RequestLine(value="PATCH /v1/tables/{id}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTable1(@Param(value="id") @Nonnull UUID var1, @Param(value="changeSource") @Nullable String var2, @Nullable Object var3);

    @RequestLine(value="PATCH /v1/tables/{id}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTable1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="changeSource") @Nullable String var2, @Nullable Object var3);

    @RequestLine(value="PATCH /v1/tables/{id}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTable1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2, @QueryMap(encoded=true) PatchTable1QueryParams var3);

    @RequestLine(value="PATCH /v1/tables/{id}?changeSource={changeSource}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTable1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2, @QueryMap(encoded=true) PatchTable1QueryParams var3);

    @RequestLine(value="PUT /v1/tables/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table restore11(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/tables/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Table> restore11WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="GET /v1/tables/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchEntityRelationshipResult searchEntityRelationship(@Param(value="fqn") @Nullable String var1, @Param(value="upstreamDepth") @Nullable Integer var2, @Param(value="downstreamDepth") @Nullable Integer var3, @Param(value="queryFilter") @Nullable String var4, @Param(value="includeDeleted") @Nullable Boolean var5, @Param(value="fields") @Nullable String var6, @Param(value="from") @Nullable Integer var7, @Param(value="size") @Nullable Integer var8);

    @RequestLine(value="GET /v1/tables/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchEntityRelationshipResult> searchEntityRelationshipWithHttpInfo(@Param(value="fqn") @Nullable String var1, @Param(value="upstreamDepth") @Nullable Integer var2, @Param(value="downstreamDepth") @Nullable Integer var3, @Param(value="queryFilter") @Nullable String var4, @Param(value="includeDeleted") @Nullable Boolean var5, @Param(value="fields") @Nullable String var6, @Param(value="from") @Nullable Integer var7, @Param(value="size") @Nullable Integer var8);

    @RequestLine(value="GET /v1/tables/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchEntityRelationshipResult searchEntityRelationship(@QueryMap(encoded=true) SearchEntityRelationshipQueryParams var1);

    @RequestLine(value="GET /v1/tables/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchEntityRelationshipResult> searchEntityRelationshipWithHttpInfo(@QueryMap(encoded=true) SearchEntityRelationshipQueryParams var1);

    @RequestLine(value="GET /v1/tables/entityRelationship/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchEntityRelationshipResult searchEntityRelationshipWithDirection(@Param(value="direction") @Nonnull String var1, @Param(value="fqn") @Nullable String var2, @Param(value="upstreamDepth") @Nullable Integer var3, @Param(value="downstreamDepth") @Nullable Integer var4, @Param(value="queryFilter") @Nullable String var5, @Param(value="includeDeleted") @Nullable Boolean var6, @Param(value="fields") @Nullable String var7, @Param(value="from") @Nullable Integer var8, @Param(value="size") @Nullable Integer var9);

    @RequestLine(value="GET /v1/tables/entityRelationship/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchEntityRelationshipResult> searchEntityRelationshipWithDirectionWithHttpInfo(@Param(value="direction") @Nonnull String var1, @Param(value="fqn") @Nullable String var2, @Param(value="upstreamDepth") @Nullable Integer var3, @Param(value="downstreamDepth") @Nullable Integer var4, @Param(value="queryFilter") @Nullable String var5, @Param(value="includeDeleted") @Nullable Boolean var6, @Param(value="fields") @Nullable String var7, @Param(value="from") @Nullable Integer var8, @Param(value="size") @Nullable Integer var9);

    @RequestLine(value="GET /v1/tables/entityRelationship/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchEntityRelationshipResult searchEntityRelationshipWithDirection(@Param(value="direction") @Nonnull String var1, @QueryMap(encoded=true) SearchEntityRelationshipWithDirectionQueryParams var2);

    @RequestLine(value="GET /v1/tables/entityRelationship/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchEntityRelationshipResult> searchEntityRelationshipWithDirectionWithHttpInfo(@Param(value="direction") @Nonnull String var1, @QueryMap(encoded=true) SearchEntityRelationshipWithDirectionQueryParams var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList searchTableColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> searchTableColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList searchTableColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) SearchTableColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> searchTableColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) SearchTableColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/tables/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList searchTableColumnsById(@Param(value="id") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/tables/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> searchTableColumnsByIdWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/tables/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableColumnList searchTableColumnsById(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) SearchTableColumnsByIdQueryParams var2);

    @RequestLine(value="GET /v1/tables/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableColumnList> searchTableColumnsByIdWithHttpInfo(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) SearchTableColumnsByIdQueryParams var2);

    @RequestLine(value="PUT /v1/tables/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity5(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/tables/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity5WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class SearchTableColumnsByIdQueryParams
    extends HashMap<String, Object> {
        public SearchTableColumnsByIdQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByIdQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByIdQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByIdQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByIdQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchTableColumnsByFQNQueryParams
    extends HashMap<String, Object> {
        public SearchTableColumnsByFQNQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByFQNQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByFQNQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchTableColumnsByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntityRelationshipWithDirectionQueryParams
    extends HashMap<String, Object> {
        public SearchEntityRelationshipWithDirectionQueryParams fqn(@Nullable String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams upstreamDepth(@Nullable Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams downstreamDepth(@Nullable Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams queryFilter(@Nullable String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams includeDeleted(@Nullable Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams from(@Nullable Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipWithDirectionQueryParams size(@Nullable Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntityRelationshipQueryParams
    extends HashMap<String, Object> {
        public SearchEntityRelationshipQueryParams fqn(@Nullable String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams upstreamDepth(@Nullable Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams downstreamDepth(@Nullable Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams queryFilter(@Nullable String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams includeDeleted(@Nullable Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams from(@Nullable Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntityRelationshipQueryParams size(@Nullable Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class PatchTable1QueryParams
    extends HashMap<String, Object> {
        public PatchTable1QueryParams changeSource(@Nullable String value) {
            this.put("changeSource", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class PatchTableQueryParams
    extends HashMap<String, Object> {
        public PatchTableQueryParams changeSource(@Nullable String value) {
            this.put("changeSource", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTablesQueryParams
    extends HashMap<String, Object> {
        public ListTablesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams database(@Nullable String value) {
            this.put("database", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams databaseSchema(@Nullable String value) {
            this.put("databaseSchema", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams includeEmptyTestSuite(@Nullable Boolean value) {
            this.put("includeEmptyTestSuite", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListSystemProfilesQueryParams
    extends HashMap<String, Object> {
        public ListSystemProfilesQueryParams startTs(@Nonnull BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListSystemProfilesQueryParams endTs(@Nonnull BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListProfilesQueryParams
    extends HashMap<String, Object> {
        public ListProfilesQueryParams startTs(@Nullable BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListProfilesQueryParams endTs(@Nullable BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListColumnProfilesQueryParams
    extends HashMap<String, Object> {
        public ListColumnProfilesQueryParams startTs(@Nonnull BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListColumnProfilesQueryParams endTs(@Nonnull BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTableAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportTableAsyncQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTableQueryParams
    extends HashMap<String, Object> {
        public ImportTableQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTheLatestTableAndColumnProfileQueryParams
    extends HashMap<String, Object> {
        public GetTheLatestTableAndColumnProfileQueryParams includeColumnProfile(@Nullable Boolean value) {
            this.put("includeColumnProfile", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableColumnsByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTableColumnsByFQNQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetTableColumnsByFQNQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public GetTableColumnsByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableColumnsByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableColumnsQueryParams
    extends HashMap<String, Object> {
        public GetTableColumnsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetTableColumnsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public GetTableColumnsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableColumnsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableByIDQueryParams
    extends HashMap<String, Object> {
        public GetTableByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTableByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTableAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteTableAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTableAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTable1QueryParams
    extends HashMap<String, Object> {
        public DeleteTable1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTable1QueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTableQueryParams
    extends HashMap<String, Object> {
        public DeleteTableQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTableQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

