/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.BulkAssets;
import org.openmetadata.client.model.BulkOperationResult;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateTeam;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Team;
import org.openmetadata.client.model.TeamList;

public interface TeamsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/teams/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult bulkAddAssets2(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/teams/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> bulkAddAssets2WithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/teams/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent bulkRemoveAssets2(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/teams/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> bulkRemoveAssets2WithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team createOrUpdateTeam(@Nullable CreateTeam var1);

    @RequestLine(value="PUT /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Team> createOrUpdateTeamWithHttpInfo(@Nullable CreateTeam var1);

    @RequestLine(value="POST /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team createTeam(@Nullable CreateTeam var1);

    @RequestLine(value="POST /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Team> createTeamWithHttpInfo(@Nullable CreateTeam var1);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeam(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeam(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTeamQueryParams var2);

    @RequestLine(value="DELETE /v1/teams/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTeamQueryParams var2);

    @RequestLine(value="DELETE /v1/teams/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeamAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/teams/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/teams/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeamAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTeamAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/teams/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTeamAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeamByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTeamByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteTeamByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/teams/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTeamByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteTeamByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/teams/{teamId}/users/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteTeamUser(@Param(value="teamId") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/teams/{teamId}/users/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteTeamUserWithHttpInfo(@Param(value="teamId") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="GET /v1/teams/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public String exportTeams(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/teams/name/{name}/export")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportTeamsWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/teams/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportTeams1(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/teams/name/{name}/exportAsync")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportTeams1WithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/teams/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public String getCsvDocumentation1(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/teams/documentation/csv")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getCsvDocumentation1WithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/teams/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Team getSpecificTeamVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/teams/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getSpecificTeamVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetTeamByFQNQueryParams var2);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetTeamByFQNQueryParams var2);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTeamByIDQueryParams var2);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Team> getTeamByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetTeamByIDQueryParams var2);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeams(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTeamsQueryParams var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTeamsQueryParams var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeamsAsync(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Nullable String var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public CsvImportResult importTeamsAsync(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTeamsAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/teams/name/{name}/importAsync?dryRun={dryRun}")
    @Headers(value={"Content-Type: text/plain", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importTeamsAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportTeamsAsyncQueryParams var3);

    @RequestLine(value="GET /v1/teams/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTeamVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/teams/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTeamVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeams(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="parentTeam") @Nullable String var5, @Param(value="isJoinable") @Nullable Boolean var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="parentTeam") @Nullable String var5, @Param(value="isJoinable") @Nullable Boolean var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeams(@QueryMap(encoded=true) ListTeamsQueryParams var1);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&parentTeam={parentTeam}&isJoinable={isJoinable}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsWithHttpInfo(@QueryMap(encoded=true) ListTeamsQueryParams var1);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeamsHierarchy(@Param(value="limit") @Nullable Integer var1, @Param(value="isJoinable") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsHierarchyWithHttpInfo(@Param(value="limit") @Nullable Integer var1, @Param(value="isJoinable") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeamsHierarchy(@QueryMap(encoded=true) ListTeamsHierarchyQueryParams var1);

    @RequestLine(value="GET /v1/teams/hierarchy?limit={limit}&isJoinable={isJoinable}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TeamList> listTeamsHierarchyWithHttpInfo(@QueryMap(encoded=true) ListTeamsHierarchyQueryParams var1);

    @RequestLine(value="PATCH /v1/teams/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTeam(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/teams/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTeamWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/teams/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTeam1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/teams/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTeam1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/teams/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team restore39(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/teams/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Team> restore39WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/teams/{teamId}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateTeamUsers(@Param(value="teamId") @Nonnull UUID var1, @Nullable List<EntityReference> var2);

    @RequestLine(value="PUT /v1/teams/{teamId}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateTeamUsersWithHttpInfo(@Param(value="teamId") @Nonnull UUID var1, @Nullable List<EntityReference> var2);

    public static class ListTeamsHierarchyQueryParams
    extends HashMap<String, Object> {
        public ListTeamsHierarchyQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsHierarchyQueryParams isJoinable(@Nullable Boolean value) {
            this.put("isJoinable", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTeamsQueryParams
    extends HashMap<String, Object> {
        public ListTeamsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams parentTeam(@Nullable String value) {
            this.put("parentTeam", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams isJoinable(@Nullable Boolean value) {
            this.put("isJoinable", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTeamsAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportTeamsAsyncQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportTeamsQueryParams
    extends HashMap<String, Object> {
        public ImportTeamsQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTeamByIDQueryParams
    extends HashMap<String, Object> {
        public GetTeamByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTeamByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTeamByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTeamByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTeamByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTeamByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTeamByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTeamAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteTeamAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTeamAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTeamQueryParams
    extends HashMap<String, Object> {
        public DeleteTeamQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTeamQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

