/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateTestSuite;
import org.openmetadata.client.model.DataQualityReport;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestSuite;
import org.openmetadata.client.model.TestSuiteList;
import org.openmetadata.client.model.TestSummary;

public interface TestSuitesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/dataQuality/testSuites/basic")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createBasicTestSuite(@Nullable CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites/basic")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createBasicTestSuiteWithHttpInfo(@Nullable CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createLogicalTestSuite(@Nullable CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createLogicalTestSuiteWithHttpInfo(@Nullable CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/basic")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateBasicTestSuite(@Nullable CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/basic")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateBasicTestSuiteWithHttpInfo(@Nullable CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateExecutableTestSuite(@Nullable CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateExecutableTestSuiteWithHttpInfo(@Nullable CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateLogicalTestSuite(@Nullable CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateLogicalTestSuiteWithHttpInfo(@Nullable CreateTestSuite var1);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteLogicalTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteLogicalTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite1(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuite1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite1(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteLogicalTestSuite1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuite1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteLogicalTestSuite1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuiteAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuiteAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteLogicalTestSuiteAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteLogicalTestSuiteAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite1(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuite1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite1(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTestSuite1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuite1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTestSuite1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteTestSuiteByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/basic/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteTestSuiteByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName1(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByName1WithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName1(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteTestSuiteByName1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByName1WithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteTestSuiteByName1QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite get5(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> get5WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite get5(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get5QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> get5WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get5QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public DataQualityReport getDataQualityReport(@Param(value="q") @Nullable String var1, @Param(value="aggregationQuery") @Nullable String var2, @Param(value="index") @Nullable String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataQualityReport> getDataQualityReportWithHttpInfo(@Param(value="q") @Nullable String var1, @Param(value="aggregationQuery") @Nullable String var2, @Param(value="index") @Nullable String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public DataQualityReport getDataQualityReport(@QueryMap(encoded=true) GetDataQualityReportQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataQualityReport> getDataQualityReportWithHttpInfo(@QueryMap(encoded=true) GetDataQualityReportQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public TestSummary getExecutionSummaryOfTestSuites(@Param(value="testSuiteId") @Nullable UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSummary> getExecutionSummaryOfTestSuitesWithHttpInfo(@Param(value="testSuiteId") @Nullable UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public TestSummary getExecutionSummaryOfTestSuites(@QueryMap(encoded=true) GetExecutionSummaryOfTestSuitesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSummary> getExecutionSummaryOfTestSuitesWithHttpInfo(@QueryMap(encoded=true) GetExecutionSummaryOfTestSuitesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getSpecificTestSuiteVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getSpecificTestSuiteVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getTestSuiteByName(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getTestSuiteByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getTestSuiteByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetTestSuiteByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getTestSuiteByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetTestSuiteByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTestSuiteVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTestSuiteVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&domain={domain}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}&queryString={queryString}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuiteFromSearchService(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable String var3, @Param(value="testSuiteType") @Nullable String var4, @Param(value="includeEmptyTestSuites") @Nullable Boolean var5, @Param(value="domain") @Nullable String var6, @Param(value="fullyQualifiedName") @Nullable String var7, @Param(value="owner") @Nullable String var8, @Param(value="include") @Nullable String var9, @Param(value="sortField") @Nullable String var10, @Param(value="sortNestedPath") @Nullable String var11, @Param(value="sortNestedMode") @Nullable String var12, @Param(value="sortType") @Nullable String var13, @Param(value="q") @Nullable String var14, @Param(value="queryString") @Nullable String var15);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&domain={domain}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}&queryString={queryString}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuiteFromSearchServiceWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable String var3, @Param(value="testSuiteType") @Nullable String var4, @Param(value="includeEmptyTestSuites") @Nullable Boolean var5, @Param(value="domain") @Nullable String var6, @Param(value="fullyQualifiedName") @Nullable String var7, @Param(value="owner") @Nullable String var8, @Param(value="include") @Nullable String var9, @Param(value="sortField") @Nullable String var10, @Param(value="sortNestedPath") @Nullable String var11, @Param(value="sortNestedMode") @Nullable String var12, @Param(value="sortType") @Nullable String var13, @Param(value="q") @Nullable String var14, @Param(value="queryString") @Nullable String var15);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&domain={domain}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}&queryString={queryString}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuiteFromSearchService(@QueryMap(encoded=true) ListTestSuiteFromSearchServiceQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&domain={domain}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}&queryString={queryString}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuiteFromSearchServiceWithHttpInfo(@QueryMap(encoded=true) ListTestSuiteFromSearchServiceQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuites(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="testSuiteType") @Nullable String var3, @Param(value="includeEmptyTestSuites") @Nullable Boolean var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuitesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="testSuiteType") @Nullable String var3, @Param(value="includeEmptyTestSuites") @Nullable Boolean var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuites(@QueryMap(encoded=true) ListTestSuitesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuitesWithHttpInfo(@QueryMap(encoded=true) ListTestSuitesQueryParams var1);

    @RequestLine(value="PATCH /v1/dataQuality/testSuites/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTestSuite(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testSuites/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestSuiteWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite restore15(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> restore15WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListTestSuitesQueryParams
    extends HashMap<String, Object> {
        public ListTestSuitesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams testSuiteType(@Nullable String value) {
            this.put("testSuiteType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams includeEmptyTestSuites(@Nullable Boolean value) {
            this.put("includeEmptyTestSuites", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTestSuiteFromSearchServiceQueryParams
    extends HashMap<String, Object> {
        public ListTestSuiteFromSearchServiceQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams offset(@Nullable String value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams testSuiteType(@Nullable String value) {
            this.put("testSuiteType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams includeEmptyTestSuites(@Nullable Boolean value) {
            this.put("includeEmptyTestSuites", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams fullyQualifiedName(@Nullable String value) {
            this.put("fullyQualifiedName", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams owner(@Nullable String value) {
            this.put("owner", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortField(@Nullable String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortNestedPath(@Nullable String value) {
            this.put("sortNestedPath", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortNestedMode(@Nullable String value) {
            this.put("sortNestedMode", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortType(@Nullable String value) {
            this.put("sortType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams queryString(@Nullable String value) {
            this.put("queryString", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTestSuiteByNameQueryParams
    extends HashMap<String, Object> {
        public GetTestSuiteByNameQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTestSuiteByNameQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetExecutionSummaryOfTestSuitesQueryParams
    extends HashMap<String, Object> {
        public GetExecutionSummaryOfTestSuitesQueryParams testSuiteId(@Nullable UUID value) {
            this.put("testSuiteId", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataQualityReportQueryParams
    extends HashMap<String, Object> {
        public GetDataQualityReportQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public GetDataQualityReportQueryParams aggregationQuery(@Nullable String value) {
            this.put("aggregationQuery", EncodingUtils.encode(value));
            return this;
        }

        public GetDataQualityReportQueryParams index(@Nullable String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get5QueryParams
    extends HashMap<String, Object> {
        public Get5QueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get5QueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteByName1QueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteByName1QueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteByName1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuite1QueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuite1QueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuite1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteQueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuiteAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuiteAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuite1QueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuite1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuiteQueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuiteQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

