/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateTopic;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.Topic;
import org.openmetadata.client.model.TopicList;
import org.openmetadata.client.model.TopicSampleData;
import org.openmetadata.client.model.VoteRequest;

public interface TopicsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/topics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower8(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/topics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower8WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/topics/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic addSampleData2(@Param(value="id") @Nonnull UUID var1, @Nullable TopicSampleData var2);

    @RequestLine(value="PUT /v1/topics/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> addSampleData2WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TopicSampleData var2);

    @RequestLine(value="PUT /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createOrUpdateTopic(@Nullable CreateTopic var1);

    @RequestLine(value="PUT /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> createOrUpdateTopicWithHttpInfo(@Nullable CreateTopic var1);

    @RequestLine(value="POST /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createTopic(@Nullable CreateTopic var1);

    @RequestLine(value="POST /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> createTopicWithHttpInfo(@Nullable CreateTopic var1);

    @RequestLine(value="DELETE /v1/topics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower22(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/topics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower22WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopic(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopic(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTopicQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTopicQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopicAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/topics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/topics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopicAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTopicAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteTopicAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopicByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTopicByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteTopicByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/topics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTopicByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteTopicByFQNQueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic get7(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> get7WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic get7(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get7QueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> get7WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) Get7QueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public Topic getSampleData2(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/topics/{id}/sampleData")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getSampleData2WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/topics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Topic getSpecificTopicVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/topics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getSpecificTopicVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic getTopicByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getTopicByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic getTopicByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTopicByFQNQueryParams var2);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Topic> getTopicByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetTopicByFQNQueryParams var2);

    @RequestLine(value="GET /v1/topics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTopicVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/topics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTopicVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TopicList listTopics(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TopicList> listTopicsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TopicList listTopics(@QueryMap(encoded=true) ListTopicsQueryParams var1);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TopicList> listTopicsWithHttpInfo(@QueryMap(encoded=true) ListTopicsQueryParams var1);

    @RequestLine(value="PATCH /v1/topics/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTopic(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/topics/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTopicWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/topics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTopic1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/topics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTopic1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/topics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic restore41(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/topics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Topic> restore41WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/topics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity15(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/topics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity15WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListTopicsQueryParams
    extends HashMap<String, Object> {
        public ListTopicsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTopicByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTopicByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTopicByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get7QueryParams
    extends HashMap<String, Object> {
        public Get7QueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get7QueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTopicByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteTopicByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTopicAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteTopicAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTopicQueryParams
    extends HashMap<String, Object> {
        public DeleteTopicQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

