/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateWorksheet;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;
import org.openmetadata.client.model.Worksheet;
import org.openmetadata.client.model.WorksheetList;

public interface WorksheetsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/drives/worksheets/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToWorksheet(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/drives/worksheets/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToWorksheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/drives/worksheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Worksheet createOrUpdateWorksheet(@Nullable CreateWorksheet var1);

    @RequestLine(value="PUT /v1/drives/worksheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Worksheet> createOrUpdateWorksheetWithHttpInfo(@Nullable CreateWorksheet var1);

    @RequestLine(value="POST /v1/drives/worksheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Worksheet createWorksheet(@Nullable CreateWorksheet var1);

    @RequestLine(value="POST /v1/drives/worksheets")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Worksheet> createWorksheetWithHttpInfo(@Nullable CreateWorksheet var1);

    @RequestLine(value="DELETE /v1/drives/worksheets/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteWorksheet(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWorksheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteWorksheet(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteWorksheetQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWorksheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteWorksheetQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteWorksheetAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/worksheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWorksheetAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/worksheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteWorksheetAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteWorksheetAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWorksheetAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteWorksheetAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteWorksheetByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWorksheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteWorksheetByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteWorksheetByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteWorksheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteWorksheetByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/worksheets/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Worksheet getSpecificWorksheetVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/worksheets/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Worksheet> getSpecificWorksheetVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/worksheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Worksheet getWorksheetByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/worksheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Worksheet> getWorksheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/worksheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Worksheet getWorksheetByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetWorksheetByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/worksheets/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Worksheet> getWorksheetByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetWorksheetByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/worksheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Worksheet getWorksheetByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/worksheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Worksheet> getWorksheetByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/worksheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Worksheet getWorksheetByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetWorksheetByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/worksheets/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Worksheet> getWorksheetByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetWorksheetByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/worksheets/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllWorksheetVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/worksheets/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllWorksheetVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/worksheets?fields={fields}&service={service}&spreadsheet={spreadsheet}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public WorksheetList listWorksheets(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="spreadsheet") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/drives/worksheets?fields={fields}&service={service}&spreadsheet={spreadsheet}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<WorksheetList> listWorksheetsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="spreadsheet") @Nullable String var3, @Param(value="limit") @Nullable Integer var4, @Param(value="before") @Nullable String var5, @Param(value="after") @Nullable String var6, @Param(value="include") @Nullable String var7);

    @RequestLine(value="GET /v1/drives/worksheets?fields={fields}&service={service}&spreadsheet={spreadsheet}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public WorksheetList listWorksheets(@QueryMap(encoded=true) ListWorksheetsQueryParams var1);

    @RequestLine(value="GET /v1/drives/worksheets?fields={fields}&service={service}&spreadsheet={spreadsheet}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<WorksheetList> listWorksheetsWithHttpInfo(@QueryMap(encoded=true) ListWorksheetsQueryParams var1);

    @RequestLine(value="PATCH /v1/drives/worksheets/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchWorksheet(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/drives/worksheets/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchWorksheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent removeFollowerFromWorksheet(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/drives/worksheets/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> removeFollowerFromWorksheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="PUT /v1/drives/worksheets/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Worksheet restoreWorksheetById(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/worksheets/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Worksheet> restoreWorksheetByIdWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/worksheets/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForWorksheet(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/drives/worksheets/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForWorksheetWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListWorksheetsQueryParams
    extends HashMap<String, Object> {
        public ListWorksheetsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListWorksheetsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListWorksheetsQueryParams spreadsheet(@Nullable String value) {
            this.put("spreadsheet", EncodingUtils.encode(value));
            return this;
        }

        public ListWorksheetsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListWorksheetsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListWorksheetsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListWorksheetsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetWorksheetByIDQueryParams
    extends HashMap<String, Object> {
        public GetWorksheetByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetWorksheetByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetWorksheetByFQNQueryParams
    extends HashMap<String, Object> {
        public GetWorksheetByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetWorksheetByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteWorksheetByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteWorksheetByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteWorksheetAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteWorksheetAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteWorksheetAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteWorksheetQueryParams
    extends HashMap<String, Object> {
        public DeleteWorksheetQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

