/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.TopHits;

@JsonPropertyOrder(value={"query", "index", "fieldName", "fieldValue", "deleted", "size", "sourceFields", "topHits"})
public class AggregationRequest {
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nullable
    private String query;
    public static final String JSON_PROPERTY_INDEX = "index";
    @Nullable
    private String index;
    public static final String JSON_PROPERTY_FIELD_NAME = "fieldName";
    @Nonnull
    private String fieldName;
    public static final String JSON_PROPERTY_FIELD_VALUE = "fieldValue";
    @Nullable
    private String fieldValue;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    @Nullable
    private Boolean deleted;
    public static final String JSON_PROPERTY_SIZE = "size";
    @Nullable
    private Integer size;
    public static final String JSON_PROPERTY_SOURCE_FIELDS = "sourceFields";
    @Nullable
    private List<String> sourceFields = new ArrayList<String>();
    public static final String JSON_PROPERTY_TOP_HITS = "topHits";
    @Nullable
    private TopHits topHits;

    public AggregationRequest query(@Nullable String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(@Nullable String query) {
        this.query = query;
    }

    public AggregationRequest index(@Nullable String index) {
        this.index = index;
        return this;
    }

    @Nullable
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndex() {
        return this.index;
    }

    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndex(@Nullable String index) {
        this.index = index;
    }

    public AggregationRequest fieldName(@Nonnull String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fieldName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty(value="fieldName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFieldName(@Nonnull String fieldName) {
        this.fieldName = fieldName;
    }

    public AggregationRequest fieldValue(@Nullable String fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    @Nullable
    @JsonProperty(value="fieldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldValue() {
        return this.fieldValue;
    }

    @JsonProperty(value="fieldValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldValue(@Nullable String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public AggregationRequest deleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
    }

    public AggregationRequest size(@Nullable Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(@Nullable Integer size) {
        this.size = size;
    }

    public AggregationRequest sourceFields(@Nullable List<String> sourceFields) {
        this.sourceFields = sourceFields;
        return this;
    }

    public AggregationRequest addSourceFieldsItem(String sourceFieldsItem) {
        if (this.sourceFields == null) {
            this.sourceFields = new ArrayList<String>();
        }
        this.sourceFields.add(sourceFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    @JsonProperty(value="sourceFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceFields(@Nullable List<String> sourceFields) {
        this.sourceFields = sourceFields;
    }

    public AggregationRequest topHits(@Nullable TopHits topHits) {
        this.topHits = topHits;
        return this;
    }

    @Nullable
    @JsonProperty(value="topHits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TopHits getTopHits() {
        return this.topHits;
    }

    @JsonProperty(value="topHits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTopHits(@Nullable TopHits topHits) {
        this.topHits = topHits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationRequest aggregationRequest = (AggregationRequest)o;
        return Objects.equals(this.query, aggregationRequest.query) && Objects.equals(this.index, aggregationRequest.index) && Objects.equals(this.fieldName, aggregationRequest.fieldName) && Objects.equals(this.fieldValue, aggregationRequest.fieldValue) && Objects.equals(this.deleted, aggregationRequest.deleted) && Objects.equals(this.size, aggregationRequest.size) && Objects.equals(this.sourceFields, aggregationRequest.sourceFields) && Objects.equals(this.topHits, aggregationRequest.topHits);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.index, this.fieldName, this.fieldValue, this.deleted, this.size, this.sourceFields, this.topHits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregationRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    fieldValue: ").append(this.toIndentedString(this.fieldValue)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    sourceFields: ").append(this.toIndentedString(this.sourceFields)).append("\n");
        sb.append("    topHits: ").append(this.toIndentedString(this.topHits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

