/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Aggregation;
import org.openmetadata.client.model.FieldBoost;
import org.openmetadata.client.model.FieldValueBoost;
import org.openmetadata.client.model.MatchTypeBoostMultipliers;
import org.openmetadata.client.model.TermBoost;

@JsonPropertyOrder(value={"assetType", "searchFields", "highlightFields", "aggregations", "termBoosts", "fieldValueBoosts", "scoreMode", "boostMode", "additionalSettings", "matchTypeBoostMultipliers"})
public class AssetTypeConfiguration {
    public static final String JSON_PROPERTY_ASSET_TYPE = "assetType";
    @Nonnull
    private String assetType;
    public static final String JSON_PROPERTY_SEARCH_FIELDS = "searchFields";
    @Nullable
    private List<FieldBoost> searchFields = new ArrayList<FieldBoost>();
    public static final String JSON_PROPERTY_HIGHLIGHT_FIELDS = "highlightFields";
    @Nullable
    private List<String> highlightFields = new ArrayList<String>();
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    @Nullable
    private List<Aggregation> aggregations = new ArrayList<Aggregation>();
    public static final String JSON_PROPERTY_TERM_BOOSTS = "termBoosts";
    @Nullable
    private List<TermBoost> termBoosts = new ArrayList<TermBoost>();
    public static final String JSON_PROPERTY_FIELD_VALUE_BOOSTS = "fieldValueBoosts";
    @Nullable
    private List<FieldValueBoost> fieldValueBoosts = new ArrayList<FieldValueBoost>();
    public static final String JSON_PROPERTY_SCORE_MODE = "scoreMode";
    @Nullable
    private ScoreModeEnum scoreMode;
    public static final String JSON_PROPERTY_BOOST_MODE = "boostMode";
    @Nullable
    private BoostModeEnum boostMode;
    public static final String JSON_PROPERTY_ADDITIONAL_SETTINGS = "additionalSettings";
    @Nullable
    private Object additionalSettings;
    public static final String JSON_PROPERTY_MATCH_TYPE_BOOST_MULTIPLIERS = "matchTypeBoostMultipliers";
    @Nullable
    private MatchTypeBoostMultipliers matchTypeBoostMultipliers;

    public AssetTypeConfiguration assetType(@Nonnull String assetType) {
        this.assetType = assetType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAssetType() {
        return this.assetType;
    }

    @JsonProperty(value="assetType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetType(@Nonnull String assetType) {
        this.assetType = assetType;
    }

    public AssetTypeConfiguration searchFields(@Nullable List<FieldBoost> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public AssetTypeConfiguration addSearchFieldsItem(FieldBoost searchFieldsItem) {
        if (this.searchFields == null) {
            this.searchFields = new ArrayList<FieldBoost>();
        }
        this.searchFields.add(searchFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="searchFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldBoost> getSearchFields() {
        return this.searchFields;
    }

    @JsonProperty(value="searchFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFields(@Nullable List<FieldBoost> searchFields) {
        this.searchFields = searchFields;
    }

    public AssetTypeConfiguration highlightFields(@Nullable List<String> highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public AssetTypeConfiguration addHighlightFieldsItem(String highlightFieldsItem) {
        if (this.highlightFields == null) {
            this.highlightFields = new ArrayList<String>();
        }
        this.highlightFields.add(highlightFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="highlightFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHighlightFields() {
        return this.highlightFields;
    }

    @JsonProperty(value="highlightFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHighlightFields(@Nullable List<String> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public AssetTypeConfiguration aggregations(@Nullable List<Aggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public AssetTypeConfiguration addAggregationsItem(Aggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<Aggregation>();
        }
        this.aggregations.add(aggregationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregations(@Nullable List<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public AssetTypeConfiguration termBoosts(@Nullable List<TermBoost> termBoosts) {
        this.termBoosts = termBoosts;
        return this;
    }

    public AssetTypeConfiguration addTermBoostsItem(TermBoost termBoostsItem) {
        if (this.termBoosts == null) {
            this.termBoosts = new ArrayList<TermBoost>();
        }
        this.termBoosts.add(termBoostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="termBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TermBoost> getTermBoosts() {
        return this.termBoosts;
    }

    @JsonProperty(value="termBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTermBoosts(@Nullable List<TermBoost> termBoosts) {
        this.termBoosts = termBoosts;
    }

    public AssetTypeConfiguration fieldValueBoosts(@Nullable List<FieldValueBoost> fieldValueBoosts) {
        this.fieldValueBoosts = fieldValueBoosts;
        return this;
    }

    public AssetTypeConfiguration addFieldValueBoostsItem(FieldValueBoost fieldValueBoostsItem) {
        if (this.fieldValueBoosts == null) {
            this.fieldValueBoosts = new ArrayList<FieldValueBoost>();
        }
        this.fieldValueBoosts.add(fieldValueBoostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fieldValueBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldValueBoost> getFieldValueBoosts() {
        return this.fieldValueBoosts;
    }

    @JsonProperty(value="fieldValueBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldValueBoosts(@Nullable List<FieldValueBoost> fieldValueBoosts) {
        this.fieldValueBoosts = fieldValueBoosts;
    }

    public AssetTypeConfiguration scoreMode(@Nullable ScoreModeEnum scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="scoreMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScoreModeEnum getScoreMode() {
        return this.scoreMode;
    }

    @JsonProperty(value="scoreMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScoreMode(@Nullable ScoreModeEnum scoreMode) {
        this.scoreMode = scoreMode;
    }

    public AssetTypeConfiguration boostMode(@Nullable BoostModeEnum boostMode) {
        this.boostMode = boostMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="boostMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BoostModeEnum getBoostMode() {
        return this.boostMode;
    }

    @JsonProperty(value="boostMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBoostMode(@Nullable BoostModeEnum boostMode) {
        this.boostMode = boostMode;
    }

    public AssetTypeConfiguration additionalSettings(@Nullable Object additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @Nullable
    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAdditionalSettings() {
        return this.additionalSettings;
    }

    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalSettings(@Nullable Object additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public AssetTypeConfiguration matchTypeBoostMultipliers(@Nullable MatchTypeBoostMultipliers matchTypeBoostMultipliers) {
        this.matchTypeBoostMultipliers = matchTypeBoostMultipliers;
        return this;
    }

    @Nullable
    @JsonProperty(value="matchTypeBoostMultipliers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MatchTypeBoostMultipliers getMatchTypeBoostMultipliers() {
        return this.matchTypeBoostMultipliers;
    }

    @JsonProperty(value="matchTypeBoostMultipliers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMatchTypeBoostMultipliers(@Nullable MatchTypeBoostMultipliers matchTypeBoostMultipliers) {
        this.matchTypeBoostMultipliers = matchTypeBoostMultipliers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetTypeConfiguration assetTypeConfiguration = (AssetTypeConfiguration)o;
        return Objects.equals(this.assetType, assetTypeConfiguration.assetType) && Objects.equals(this.searchFields, assetTypeConfiguration.searchFields) && Objects.equals(this.highlightFields, assetTypeConfiguration.highlightFields) && Objects.equals(this.aggregations, assetTypeConfiguration.aggregations) && Objects.equals(this.termBoosts, assetTypeConfiguration.termBoosts) && Objects.equals(this.fieldValueBoosts, assetTypeConfiguration.fieldValueBoosts) && Objects.equals((Object)this.scoreMode, (Object)assetTypeConfiguration.scoreMode) && Objects.equals((Object)this.boostMode, (Object)assetTypeConfiguration.boostMode) && Objects.equals(this.additionalSettings, assetTypeConfiguration.additionalSettings) && Objects.equals(this.matchTypeBoostMultipliers, assetTypeConfiguration.matchTypeBoostMultipliers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetType, this.searchFields, this.highlightFields, this.aggregations, this.termBoosts, this.fieldValueBoosts, this.scoreMode, this.boostMode, this.additionalSettings, this.matchTypeBoostMultipliers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetTypeConfiguration {\n");
        sb.append("    assetType: ").append(this.toIndentedString(this.assetType)).append("\n");
        sb.append("    searchFields: ").append(this.toIndentedString(this.searchFields)).append("\n");
        sb.append("    highlightFields: ").append(this.toIndentedString(this.highlightFields)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    termBoosts: ").append(this.toIndentedString(this.termBoosts)).append("\n");
        sb.append("    fieldValueBoosts: ").append(this.toIndentedString(this.fieldValueBoosts)).append("\n");
        sb.append("    scoreMode: ").append(this.toIndentedString((Object)this.scoreMode)).append("\n");
        sb.append("    boostMode: ").append(this.toIndentedString((Object)this.boostMode)).append("\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    matchTypeBoostMultipliers: ").append(this.toIndentedString(this.matchTypeBoostMultipliers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScoreModeEnum {
        MULTIPLY(String.valueOf("multiply")),
        SUM(String.valueOf("sum")),
        AVG(String.valueOf("avg")),
        FIRST(String.valueOf("first")),
        MAX(String.valueOf("max")),
        MIN(String.valueOf("min"));

        private String value;

        private ScoreModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScoreModeEnum fromValue(String value) {
            for (ScoreModeEnum b : ScoreModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BoostModeEnum {
        MULTIPLY(String.valueOf("multiply")),
        REPLACE(String.valueOf("replace")),
        SUM(String.valueOf("sum")),
        AVG(String.valueOf("avg")),
        MAX(String.valueOf("max")),
        MIN(String.valueOf("min"));

        private String value;

        private BoostModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BoostModeEnum fromValue(String value) {
            for (BoostModeEnum b : BoostModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

