/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ChangeDescription;

@JsonPropertyOrder(value={"id", "eventType", "entityType", "entityId", "domains", "entityFullyQualifiedName", "previousVersion", "currentVersion", "userName", "timestamp", "changeDescription", "incrementalChangeDescription", "entity"})
public class ChangeEvent {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    @Nonnull
    private EventTypeEnum eventType;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    @Nonnull
    private String entityType;
    public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
    @Nonnull
    private UUID entityId;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<UUID> domains = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_ENTITY_FULLY_QUALIFIED_NAME = "entityFullyQualifiedName";
    @Nullable
    private String entityFullyQualifiedName;
    public static final String JSON_PROPERTY_PREVIOUS_VERSION = "previousVersion";
    @Nullable
    private Double previousVersion;
    public static final String JSON_PROPERTY_CURRENT_VERSION = "currentVersion";
    @Nullable
    private Double currentVersion;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    @Nullable
    private String userName;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    @Nonnull
    private Long timestamp;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    @Nullable
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_INCREMENTAL_CHANGE_DESCRIPTION = "incrementalChangeDescription";
    @Nullable
    private ChangeDescription incrementalChangeDescription;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nullable
    private Object entity;

    public ChangeEvent id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public ChangeEvent eventType(@Nonnull EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventType(@Nonnull EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public ChangeEvent entityType(@Nonnull String entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityType(@Nonnull String entityType) {
        this.entityType = entityType;
    }

    public ChangeEvent entityId(@Nonnull UUID entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityId(@Nonnull UUID entityId) {
        this.entityId = entityId;
    }

    public ChangeEvent domains(@Nullable List<UUID> domains) {
        this.domains = domains;
        return this;
    }

    public ChangeEvent addDomainsItem(UUID domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<UUID>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<UUID> domains) {
        this.domains = domains;
    }

    public ChangeEvent entityFullyQualifiedName(@Nullable String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="entityFullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntityFullyQualifiedName() {
        return this.entityFullyQualifiedName;
    }

    @JsonProperty(value="entityFullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityFullyQualifiedName(@Nullable String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
    }

    public ChangeEvent previousVersion(@Nullable Double previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="previousVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPreviousVersion() {
        return this.previousVersion;
    }

    @JsonProperty(value="previousVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreviousVersion(@Nullable Double previousVersion) {
        this.previousVersion = previousVersion;
    }

    public ChangeEvent currentVersion(@Nullable Double currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="currentVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCurrentVersion() {
        return this.currentVersion;
    }

    @JsonProperty(value="currentVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentVersion(@Nullable Double currentVersion) {
        this.currentVersion = currentVersion;
    }

    public ChangeEvent userName(@Nullable String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(@Nullable String userName) {
        this.userName = userName;
    }

    public ChangeEvent timestamp(@Nonnull Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(@Nonnull Long timestamp) {
        this.timestamp = timestamp;
    }

    public ChangeEvent changeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public ChangeEvent incrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getIncrementalChangeDescription() {
        return this.incrementalChangeDescription;
    }

    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
    }

    public ChangeEvent entity(@Nullable Object entity) {
        this.entity = entity;
        return this;
    }

    @Nullable
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(@Nullable Object entity) {
        this.entity = entity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent changeEvent = (ChangeEvent)o;
        return Objects.equals(this.id, changeEvent.id) && Objects.equals((Object)this.eventType, (Object)changeEvent.eventType) && Objects.equals(this.entityType, changeEvent.entityType) && Objects.equals(this.entityId, changeEvent.entityId) && Objects.equals(this.domains, changeEvent.domains) && Objects.equals(this.entityFullyQualifiedName, changeEvent.entityFullyQualifiedName) && Objects.equals(this.previousVersion, changeEvent.previousVersion) && Objects.equals(this.currentVersion, changeEvent.currentVersion) && Objects.equals(this.userName, changeEvent.userName) && Objects.equals(this.timestamp, changeEvent.timestamp) && Objects.equals(this.changeDescription, changeEvent.changeDescription) && Objects.equals(this.incrementalChangeDescription, changeEvent.incrementalChangeDescription) && Objects.equals(this.entity, changeEvent.entity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.eventType, this.entityType, this.entityId, this.domains, this.entityFullyQualifiedName, this.previousVersion, this.currentVersion, this.userName, this.timestamp, this.changeDescription, this.incrementalChangeDescription, this.entity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangeEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    entityFullyQualifiedName: ").append(this.toIndentedString(this.entityFullyQualifiedName)).append("\n");
        sb.append("    previousVersion: ").append(this.toIndentedString(this.previousVersion)).append("\n");
        sb.append("    currentVersion: ").append(this.toIndentedString(this.currentVersion)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    incrementalChangeDescription: ").append(this.toIndentedString(this.incrementalChangeDescription)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        ENTITY_CREATED(String.valueOf("entityCreated")),
        ENTITY_UPDATED(String.valueOf("entityUpdated")),
        ENTITY_FIELDS_CHANGED(String.valueOf("entityFieldsChanged")),
        ENTITY_NO_CHANGE(String.valueOf("entityNoChange")),
        ENTITY_SOFT_DELETED(String.valueOf("entitySoftDeleted")),
        ENTITY_DELETED(String.valueOf("entityDeleted")),
        ENTITY_RESTORED(String.valueOf("entityRestored")),
        THREAD_CREATED(String.valueOf("threadCreated")),
        THREAD_UPDATED(String.valueOf("threadUpdated")),
        POST_CREATED(String.valueOf("postCreated")),
        POST_UPDATED(String.valueOf("postUpdated")),
        TASK_RESOLVED(String.valueOf("taskResolved")),
        TASK_CLOSED(String.valueOf("taskClosed")),
        LOGICAL_TEST_CASE_ADDED(String.valueOf("logicalTestCaseAdded")),
        SUGGESTION_CREATED(String.valueOf("suggestionCreated")),
        SUGGESTION_UPDATED(String.valueOf("suggestionUpdated")),
        SUGGESTION_ACCEPTED(String.valueOf("suggestionAccepted")),
        SUGGESTION_REJECTED(String.valueOf("suggestionRejected")),
        SUGGESTION_DELETED(String.valueOf("suggestionDeleted"));

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

