/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "description", "provider", "mutuallyExclusive", "domains", "owners", "lifeCycle", "reviewers", "extension", "tags", "dataProducts"})
public class CreateClassification {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_MUTUALLY_EXCLUSIVE = "mutuallyExclusive";
    @Nullable
    private Boolean mutuallyExclusive;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();

    public CreateClassification name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateClassification displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateClassification description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public CreateClassification provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public CreateClassification mutuallyExclusive(@Nullable Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
        return this;
    }

    @Nullable
    @JsonProperty(value="mutuallyExclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMutuallyExclusive() {
        return this.mutuallyExclusive;
    }

    @JsonProperty(value="mutuallyExclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMutuallyExclusive(@Nullable Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
    }

    public CreateClassification domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateClassification addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateClassification owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateClassification addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateClassification lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateClassification reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateClassification addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateClassification extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateClassification tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateClassification addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateClassification dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateClassification addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateClassification createClassification = (CreateClassification)o;
        return Objects.equals(this.name, createClassification.name) && Objects.equals(this.displayName, createClassification.displayName) && Objects.equals(this.description, createClassification.description) && Objects.equals((Object)this.provider, (Object)createClassification.provider) && Objects.equals(this.mutuallyExclusive, createClassification.mutuallyExclusive) && Objects.equals(this.domains, createClassification.domains) && Objects.equals(this.owners, createClassification.owners) && Objects.equals(this.lifeCycle, createClassification.lifeCycle) && Objects.equals(this.reviewers, createClassification.reviewers) && Objects.equals(this.extension, createClassification.extension) && Objects.equals(this.tags, createClassification.tags) && Objects.equals(this.dataProducts, createClassification.dataProducts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.provider, this.mutuallyExclusive, this.domains, this.owners, this.lifeCycle, this.reviewers, this.extension, this.tags, this.dataProducts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateClassification {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    mutuallyExclusive: ").append(this.toIndentedString(this.mutuallyExclusive)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

