/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.SemanticsRule;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "description", "status", "entity", "schema", "semantics", "qualityExpectations", "owners", "reviewers", "effectiveFrom", "effectiveUntil", "sourceUrl", "domains", "lifeCycle", "extension", "tags", "dataProducts"})
public class CreateDataContract {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private StatusEnum status;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nonnull
    private EntityReference entity;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nullable
    private List<Column> schema = new ArrayList<Column>();
    public static final String JSON_PROPERTY_SEMANTICS = "semantics";
    @Nullable
    private List<SemanticsRule> semantics = new ArrayList<SemanticsRule>();
    public static final String JSON_PROPERTY_QUALITY_EXPECTATIONS = "qualityExpectations";
    @Nullable
    private List<EntityReference> qualityExpectations = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EFFECTIVE_FROM = "effectiveFrom";
    @Nullable
    private OffsetDateTime effectiveFrom;
    public static final String JSON_PROPERTY_EFFECTIVE_UNTIL = "effectiveUntil";
    @Nullable
    private OffsetDateTime effectiveUntil;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    @Nullable
    private String sourceUrl;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();

    public CreateDataContract name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateDataContract displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateDataContract description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CreateDataContract status(@Nullable StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(@Nullable StatusEnum status) {
        this.status = status;
    }

    public CreateDataContract entity(@Nonnull EntityReference entity) {
        this.entity = entity;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntity(@Nonnull EntityReference entity) {
        this.entity = entity;
    }

    public CreateDataContract schema(@Nullable List<Column> schema) {
        this.schema = schema;
        return this;
    }

    public CreateDataContract addSchemaItem(Column schemaItem) {
        if (this.schema == null) {
            this.schema = new ArrayList<Column>();
        }
        this.schema.add(schemaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Column> getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(@Nullable List<Column> schema) {
        this.schema = schema;
    }

    public CreateDataContract semantics(@Nullable List<SemanticsRule> semantics) {
        this.semantics = semantics;
        return this;
    }

    public CreateDataContract addSemanticsItem(SemanticsRule semanticsItem) {
        if (this.semantics == null) {
            this.semantics = new ArrayList<SemanticsRule>();
        }
        this.semantics.add(semanticsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="semantics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SemanticsRule> getSemantics() {
        return this.semantics;
    }

    @JsonProperty(value="semantics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSemantics(@Nullable List<SemanticsRule> semantics) {
        this.semantics = semantics;
    }

    public CreateDataContract qualityExpectations(@Nullable List<EntityReference> qualityExpectations) {
        this.qualityExpectations = qualityExpectations;
        return this;
    }

    public CreateDataContract addQualityExpectationsItem(EntityReference qualityExpectationsItem) {
        if (this.qualityExpectations == null) {
            this.qualityExpectations = new ArrayList<EntityReference>();
        }
        this.qualityExpectations.add(qualityExpectationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="qualityExpectations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getQualityExpectations() {
        return this.qualityExpectations;
    }

    @JsonProperty(value="qualityExpectations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQualityExpectations(@Nullable List<EntityReference> qualityExpectations) {
        this.qualityExpectations = qualityExpectations;
    }

    public CreateDataContract owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateDataContract addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateDataContract reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateDataContract addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateDataContract effectiveFrom(@Nullable OffsetDateTime effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
        return this;
    }

    @Nullable
    @JsonProperty(value="effectiveFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEffectiveFrom() {
        return this.effectiveFrom;
    }

    @JsonProperty(value="effectiveFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEffectiveFrom(@Nullable OffsetDateTime effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public CreateDataContract effectiveUntil(@Nullable OffsetDateTime effectiveUntil) {
        this.effectiveUntil = effectiveUntil;
        return this;
    }

    @Nullable
    @JsonProperty(value="effectiveUntil")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEffectiveUntil() {
        return this.effectiveUntil;
    }

    @JsonProperty(value="effectiveUntil")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEffectiveUntil(@Nullable OffsetDateTime effectiveUntil) {
        this.effectiveUntil = effectiveUntil;
    }

    public CreateDataContract sourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateDataContract domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateDataContract addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateDataContract lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateDataContract extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateDataContract tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateDataContract addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateDataContract dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateDataContract addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDataContract createDataContract = (CreateDataContract)o;
        return Objects.equals(this.name, createDataContract.name) && Objects.equals(this.displayName, createDataContract.displayName) && Objects.equals(this.description, createDataContract.description) && Objects.equals((Object)this.status, (Object)createDataContract.status) && Objects.equals(this.entity, createDataContract.entity) && Objects.equals(this.schema, createDataContract.schema) && Objects.equals(this.semantics, createDataContract.semantics) && Objects.equals(this.qualityExpectations, createDataContract.qualityExpectations) && Objects.equals(this.owners, createDataContract.owners) && Objects.equals(this.reviewers, createDataContract.reviewers) && Objects.equals(this.effectiveFrom, createDataContract.effectiveFrom) && Objects.equals(this.effectiveUntil, createDataContract.effectiveUntil) && Objects.equals(this.sourceUrl, createDataContract.sourceUrl) && Objects.equals(this.domains, createDataContract.domains) && Objects.equals(this.lifeCycle, createDataContract.lifeCycle) && Objects.equals(this.extension, createDataContract.extension) && Objects.equals(this.tags, createDataContract.tags) && Objects.equals(this.dataProducts, createDataContract.dataProducts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.status, this.entity, this.schema, this.semantics, this.qualityExpectations, this.owners, this.reviewers, this.effectiveFrom, this.effectiveUntil, this.sourceUrl, this.domains, this.lifeCycle, this.extension, this.tags, this.dataProducts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDataContract {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    semantics: ").append(this.toIndentedString(this.semantics)).append("\n");
        sb.append("    qualityExpectations: ").append(this.toIndentedString(this.qualityExpectations)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    effectiveFrom: ").append(this.toIndentedString(this.effectiveFrom)).append("\n");
        sb.append("    effectiveUntil: ").append(this.toIndentedString(this.effectiveUntil)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT(String.valueOf("Draft")),
        ACTIVE(String.valueOf("Active")),
        DEPRECATED(String.valueOf("Deprecated"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

