/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.DatabaseConnection;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "description", "tags", "serviceType", "connection", "owners", "dataProducts", "domains", "ingestionRunner", "lifeCycle", "reviewers", "extension"})
public class CreateDatabaseService {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    @Nonnull
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    @Nullable
    private DatabaseConnection connection;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_INGESTION_RUNNER = "ingestionRunner";
    @Nullable
    private EntityReference ingestionRunner;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;

    public CreateDatabaseService name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateDatabaseService displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateDatabaseService description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CreateDatabaseService tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateDatabaseService addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateDatabaseService serviceType(@Nonnull ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceType(@Nonnull ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public CreateDatabaseService connection(@Nullable DatabaseConnection connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DatabaseConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(@Nullable DatabaseConnection connection) {
        this.connection = connection;
    }

    public CreateDatabaseService owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateDatabaseService addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateDatabaseService dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateDatabaseService addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateDatabaseService domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateDatabaseService addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateDatabaseService ingestionRunner(@Nullable EntityReference ingestionRunner) {
        this.ingestionRunner = ingestionRunner;
        return this;
    }

    @Nullable
    @JsonProperty(value="ingestionRunner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getIngestionRunner() {
        return this.ingestionRunner;
    }

    @JsonProperty(value="ingestionRunner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIngestionRunner(@Nullable EntityReference ingestionRunner) {
        this.ingestionRunner = ingestionRunner;
    }

    public CreateDatabaseService lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateDatabaseService reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateDatabaseService addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateDatabaseService extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDatabaseService createDatabaseService = (CreateDatabaseService)o;
        return Objects.equals(this.name, createDatabaseService.name) && Objects.equals(this.displayName, createDatabaseService.displayName) && Objects.equals(this.description, createDatabaseService.description) && Objects.equals(this.tags, createDatabaseService.tags) && Objects.equals((Object)this.serviceType, (Object)createDatabaseService.serviceType) && Objects.equals(this.connection, createDatabaseService.connection) && Objects.equals(this.owners, createDatabaseService.owners) && Objects.equals(this.dataProducts, createDatabaseService.dataProducts) && Objects.equals(this.domains, createDatabaseService.domains) && Objects.equals(this.ingestionRunner, createDatabaseService.ingestionRunner) && Objects.equals(this.lifeCycle, createDatabaseService.lifeCycle) && Objects.equals(this.reviewers, createDatabaseService.reviewers) && Objects.equals(this.extension, createDatabaseService.extension);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.tags, this.serviceType, this.connection, this.owners, this.dataProducts, this.domains, this.ingestionRunner, this.lifeCycle, this.reviewers, this.extension});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDatabaseService {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    connection: ").append(this.toIndentedString(this.connection)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    ingestionRunner: ").append(this.toIndentedString(this.ingestionRunner)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ServiceTypeEnum {
        BIG_QUERY(String.valueOf("BigQuery")),
        BIG_TABLE(String.valueOf("BigTable")),
        MYSQL(String.valueOf("Mysql")),
        REDSHIFT(String.valueOf("Redshift")),
        SNOWFLAKE(String.valueOf("Snowflake")),
        POSTGRES(String.valueOf("Postgres")),
        MSSQL(String.valueOf("Mssql")),
        ORACLE(String.valueOf("Oracle")),
        ATHENA(String.valueOf("Athena")),
        HIVE(String.valueOf("Hive")),
        IMPALA(String.valueOf("Impala")),
        PRESTO(String.valueOf("Presto")),
        TRINO(String.valueOf("Trino")),
        VERTICA(String.valueOf("Vertica")),
        GLUE(String.valueOf("Glue")),
        MARIA_DB(String.valueOf("MariaDB")),
        DRUID(String.valueOf("Druid")),
        DB2(String.valueOf("Db2")),
        CLICKHOUSE(String.valueOf("Clickhouse")),
        DATABRICKS(String.valueOf("Databricks")),
        AZURE_SQL(String.valueOf("AzureSQL")),
        DYNAMO_DB(String.valueOf("DynamoDB")),
        SINGLE_STORE(String.valueOf("SingleStore")),
        SQ_LITE(String.valueOf("SQLite")),
        DELTA_LAKE(String.valueOf("DeltaLake")),
        SALESFORCE(String.valueOf("Salesforce")),
        PINOT_DB(String.valueOf("PinotDB")),
        DATALAKE(String.valueOf("Datalake")),
        DOMO_DATABASE(String.valueOf("DomoDatabase")),
        QUERY_LOG(String.valueOf("QueryLog")),
        CUSTOM_DATABASE(String.valueOf("CustomDatabase")),
        DBT(String.valueOf("Dbt")),
        SAP_HANA(String.valueOf("SapHana")),
        MONGO_DB(String.valueOf("MongoDB")),
        CASSANDRA(String.valueOf("Cassandra")),
        COUCHBASE(String.valueOf("Couchbase")),
        GREENPLUM(String.valueOf("Greenplum")),
        DORIS(String.valueOf("Doris")),
        UNITY_CATALOG(String.valueOf("UnityCatalog")),
        SAS(String.valueOf("SAS")),
        ICEBERG(String.valueOf("Iceberg")),
        TERADATA(String.valueOf("Teradata")),
        SAP_ERP(String.valueOf("SapErp")),
        SYNAPSE(String.valueOf("Synapse")),
        EXASOL(String.valueOf("Exasol")),
        COCKROACH(String.valueOf("Cockroach")),
        SSAS(String.valueOf("SSAS")),
        EPIC(String.valueOf("Epic"));

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

