/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "description", "service", "parent", "directoryType", "path", "isShared", "numberOfFiles", "numberOfSubDirectories", "totalSize", "sourceUrl", "tags", "owners", "dataProducts", "domains", "lifeCycle", "sourceHash", "extension", "reviewers"})
public class CreateDirectory {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_SERVICE = "service";
    @Nonnull
    private String service;
    public static final String JSON_PROPERTY_PARENT = "parent";
    @Nullable
    private String parent;
    public static final String JSON_PROPERTY_DIRECTORY_TYPE = "directoryType";
    @Nullable
    private DirectoryTypeEnum directoryType;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private String path;
    public static final String JSON_PROPERTY_IS_SHARED = "isShared";
    @Nullable
    private Boolean isShared;
    public static final String JSON_PROPERTY_NUMBER_OF_FILES = "numberOfFiles";
    @Nullable
    private Integer numberOfFiles;
    public static final String JSON_PROPERTY_NUMBER_OF_SUB_DIRECTORIES = "numberOfSubDirectories";
    @Nullable
    private Integer numberOfSubDirectories;
    public static final String JSON_PROPERTY_TOTAL_SIZE = "totalSize";
    @Nullable
    private Integer totalSize;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    @Nullable
    private String sourceUrl;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    @Nullable
    private String sourceHash;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();

    public CreateDirectory name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateDirectory displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateDirectory description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CreateDirectory service(@Nonnull String service) {
        this.service = service;
        return this;
    }

    @Nonnull
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setService(@Nonnull String service) {
        this.service = service;
    }

    public CreateDirectory parent(@Nullable String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParent(@Nullable String parent) {
        this.parent = parent;
    }

    public CreateDirectory directoryType(@Nullable DirectoryTypeEnum directoryType) {
        this.directoryType = directoryType;
        return this;
    }

    @Nullable
    @JsonProperty(value="directoryType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectoryTypeEnum getDirectoryType() {
        return this.directoryType;
    }

    @JsonProperty(value="directoryType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectoryType(@Nullable DirectoryTypeEnum directoryType) {
        this.directoryType = directoryType;
    }

    public CreateDirectory path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public CreateDirectory isShared(@Nullable Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    @Nullable
    @JsonProperty(value="isShared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsShared() {
        return this.isShared;
    }

    @JsonProperty(value="isShared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsShared(@Nullable Boolean isShared) {
        this.isShared = isShared;
    }

    public CreateDirectory numberOfFiles(@Nullable Integer numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfFiles() {
        return this.numberOfFiles;
    }

    @JsonProperty(value="numberOfFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfFiles(@Nullable Integer numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public CreateDirectory numberOfSubDirectories(@Nullable Integer numberOfSubDirectories) {
        this.numberOfSubDirectories = numberOfSubDirectories;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfSubDirectories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfSubDirectories() {
        return this.numberOfSubDirectories;
    }

    @JsonProperty(value="numberOfSubDirectories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfSubDirectories(@Nullable Integer numberOfSubDirectories) {
        this.numberOfSubDirectories = numberOfSubDirectories;
    }

    public CreateDirectory totalSize(@Nullable Integer totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalSize() {
        return this.totalSize;
    }

    @JsonProperty(value="totalSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalSize(@Nullable Integer totalSize) {
        this.totalSize = totalSize;
    }

    public CreateDirectory sourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateDirectory tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateDirectory addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateDirectory owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateDirectory addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateDirectory dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateDirectory addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateDirectory domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateDirectory addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateDirectory lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateDirectory sourceHash(@Nullable String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(@Nullable String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public CreateDirectory extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateDirectory reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateDirectory addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDirectory createDirectory = (CreateDirectory)o;
        return Objects.equals(this.name, createDirectory.name) && Objects.equals(this.displayName, createDirectory.displayName) && Objects.equals(this.description, createDirectory.description) && Objects.equals(this.service, createDirectory.service) && Objects.equals(this.parent, createDirectory.parent) && Objects.equals((Object)this.directoryType, (Object)createDirectory.directoryType) && Objects.equals(this.path, createDirectory.path) && Objects.equals(this.isShared, createDirectory.isShared) && Objects.equals(this.numberOfFiles, createDirectory.numberOfFiles) && Objects.equals(this.numberOfSubDirectories, createDirectory.numberOfSubDirectories) && Objects.equals(this.totalSize, createDirectory.totalSize) && Objects.equals(this.sourceUrl, createDirectory.sourceUrl) && Objects.equals(this.tags, createDirectory.tags) && Objects.equals(this.owners, createDirectory.owners) && Objects.equals(this.dataProducts, createDirectory.dataProducts) && Objects.equals(this.domains, createDirectory.domains) && Objects.equals(this.lifeCycle, createDirectory.lifeCycle) && Objects.equals(this.sourceHash, createDirectory.sourceHash) && Objects.equals(this.extension, createDirectory.extension) && Objects.equals(this.reviewers, createDirectory.reviewers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.service, this.parent, this.directoryType, this.path, this.isShared, this.numberOfFiles, this.numberOfSubDirectories, this.totalSize, this.sourceUrl, this.tags, this.owners, this.dataProducts, this.domains, this.lifeCycle, this.sourceHash, this.extension, this.reviewers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDirectory {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    directoryType: ").append(this.toIndentedString((Object)this.directoryType)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    isShared: ").append(this.toIndentedString(this.isShared)).append("\n");
        sb.append("    numberOfFiles: ").append(this.toIndentedString(this.numberOfFiles)).append("\n");
        sb.append("    numberOfSubDirectories: ").append(this.toIndentedString(this.numberOfSubDirectories)).append("\n");
        sb.append("    totalSize: ").append(this.toIndentedString(this.totalSize)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DirectoryTypeEnum {
        ROOT(String.valueOf("Root")),
        MY_DRIVE(String.valueOf("MyDrive")),
        SHARED_DRIVE(String.valueOf("SharedDrive")),
        TEAM_DRIVE(String.valueOf("TeamDrive")),
        FOLDER(String.valueOf("Folder")),
        SHARE_POINT_SITE(String.valueOf("SharePointSite")),
        SHARE_POINT_LIBRARY(String.valueOf("SharePointLibrary"));

        private String value;

        private DirectoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectoryTypeEnum fromValue(String value) {
            for (DirectoryTypeEnum b : DirectoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

