/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.MetricExpression;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "description", "metricExpression", "metricType", "unitOfMeasurement", "granularity", "relatedMetrics", "owners", "tags", "domains", "dataProducts", "extension", "lifeCycle", "reviewers"})
public class CreateMetric {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_METRIC_EXPRESSION = "metricExpression";
    @Nullable
    private MetricExpression metricExpression;
    public static final String JSON_PROPERTY_METRIC_TYPE = "metricType";
    @Nullable
    private MetricTypeEnum metricType;
    public static final String JSON_PROPERTY_UNIT_OF_MEASUREMENT = "unitOfMeasurement";
    @Nullable
    private UnitOfMeasurementEnum unitOfMeasurement;
    public static final String JSON_PROPERTY_GRANULARITY = "granularity";
    @Nullable
    private GranularityEnum granularity;
    public static final String JSON_PROPERTY_RELATED_METRICS = "relatedMetrics";
    @Nullable
    private List<String> relatedMetrics = new ArrayList<String>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();

    public CreateMetric name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateMetric displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateMetric description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CreateMetric metricExpression(@Nullable MetricExpression metricExpression) {
        this.metricExpression = metricExpression;
        return this;
    }

    @Nullable
    @JsonProperty(value="metricExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricExpression getMetricExpression() {
        return this.metricExpression;
    }

    @JsonProperty(value="metricExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetricExpression(@Nullable MetricExpression metricExpression) {
        this.metricExpression = metricExpression;
    }

    public CreateMetric metricType(@Nullable MetricTypeEnum metricType) {
        this.metricType = metricType;
        return this;
    }

    @Nullable
    @JsonProperty(value="metricType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricTypeEnum getMetricType() {
        return this.metricType;
    }

    @JsonProperty(value="metricType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetricType(@Nullable MetricTypeEnum metricType) {
        this.metricType = metricType;
    }

    public CreateMetric unitOfMeasurement(@Nullable UnitOfMeasurementEnum unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
        return this;
    }

    @Nullable
    @JsonProperty(value="unitOfMeasurement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnitOfMeasurementEnum getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    @JsonProperty(value="unitOfMeasurement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitOfMeasurement(@Nullable UnitOfMeasurementEnum unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
    }

    public CreateMetric granularity(@Nullable GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @Nullable
    @JsonProperty(value="granularity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    @JsonProperty(value="granularity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGranularity(@Nullable GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public CreateMetric relatedMetrics(@Nullable List<String> relatedMetrics) {
        this.relatedMetrics = relatedMetrics;
        return this;
    }

    public CreateMetric addRelatedMetricsItem(String relatedMetricsItem) {
        if (this.relatedMetrics == null) {
            this.relatedMetrics = new ArrayList<String>();
        }
        this.relatedMetrics.add(relatedMetricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relatedMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRelatedMetrics() {
        return this.relatedMetrics;
    }

    @JsonProperty(value="relatedMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelatedMetrics(@Nullable List<String> relatedMetrics) {
        this.relatedMetrics = relatedMetrics;
    }

    public CreateMetric owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateMetric addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateMetric tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateMetric addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateMetric domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateMetric addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateMetric dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateMetric addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateMetric extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateMetric lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateMetric reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateMetric addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMetric createMetric = (CreateMetric)o;
        return Objects.equals(this.name, createMetric.name) && Objects.equals(this.displayName, createMetric.displayName) && Objects.equals(this.description, createMetric.description) && Objects.equals(this.metricExpression, createMetric.metricExpression) && Objects.equals((Object)this.metricType, (Object)createMetric.metricType) && Objects.equals((Object)this.unitOfMeasurement, (Object)createMetric.unitOfMeasurement) && Objects.equals((Object)this.granularity, (Object)createMetric.granularity) && Objects.equals(this.relatedMetrics, createMetric.relatedMetrics) && Objects.equals(this.owners, createMetric.owners) && Objects.equals(this.tags, createMetric.tags) && Objects.equals(this.domains, createMetric.domains) && Objects.equals(this.dataProducts, createMetric.dataProducts) && Objects.equals(this.extension, createMetric.extension) && Objects.equals(this.lifeCycle, createMetric.lifeCycle) && Objects.equals(this.reviewers, createMetric.reviewers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.description, this.metricExpression, this.metricType, this.unitOfMeasurement, this.granularity, this.relatedMetrics, this.owners, this.tags, this.domains, this.dataProducts, this.extension, this.lifeCycle, this.reviewers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMetric {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metricExpression: ").append(this.toIndentedString(this.metricExpression)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString((Object)this.metricType)).append("\n");
        sb.append("    unitOfMeasurement: ").append(this.toIndentedString((Object)this.unitOfMeasurement)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    relatedMetrics: ").append(this.toIndentedString(this.relatedMetrics)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricTypeEnum {
        COUNT(String.valueOf("COUNT")),
        SUM(String.valueOf("SUM")),
        AVERAGE(String.valueOf("AVERAGE")),
        RATIO(String.valueOf("RATIO")),
        PERCENTAGE(String.valueOf("PERCENTAGE")),
        MIN(String.valueOf("MIN")),
        MAX(String.valueOf("MAX")),
        MEDIAN(String.valueOf("MEDIAN")),
        MODE(String.valueOf("MODE")),
        STANDARD_DEVIATION(String.valueOf("STANDARD_DEVIATION")),
        VARIANCE(String.valueOf("VARIANCE")),
        OTHER(String.valueOf("OTHER"));

        private String value;

        private MetricTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricTypeEnum fromValue(String value) {
            for (MetricTypeEnum b : MetricTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum UnitOfMeasurementEnum {
        COUNT(String.valueOf("COUNT")),
        DOLLARS(String.valueOf("DOLLARS")),
        PERCENTAGE(String.valueOf("PERCENTAGE")),
        TIMESTAMP(String.valueOf("TIMESTAMP")),
        SIZE(String.valueOf("SIZE")),
        REQUESTS(String.valueOf("REQUESTS")),
        EVENTS(String.valueOf("EVENTS")),
        TRANSACTIONS(String.valueOf("TRANSACTIONS"));

        private String value;

        private UnitOfMeasurementEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UnitOfMeasurementEnum fromValue(String value) {
            for (UnitOfMeasurementEnum b : UnitOfMeasurementEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum GranularityEnum {
        SECOND(String.valueOf("SECOND")),
        MINUTE(String.valueOf("MINUTE")),
        HOUR(String.valueOf("HOUR")),
        DAY(String.valueOf("DAY")),
        WEEK(String.valueOf("WEEK")),
        MONTH(String.valueOf("MONTH")),
        QUARTER(String.valueOf("QUARTER")),
        YEAR(String.valueOf("YEAR"));

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GranularityEnum fromValue(String value) {
            for (GranularityEnum b : GranularityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

