/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"tokenName", "JWTTokenExpiry"})
public class CreatePersonalToken {
    public static final String JSON_PROPERTY_TOKEN_NAME = "tokenName";
    @Nonnull
    private String tokenName;
    public static final String JSON_PROPERTY_JW_T_TOKEN_EXPIRY = "JWTTokenExpiry";
    @Nonnull
    private JwTTokenExpiryEnum jwTTokenExpiry;

    public CreatePersonalToken tokenName(@Nonnull String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tokenName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTokenName() {
        return this.tokenName;
    }

    @JsonProperty(value="tokenName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenName(@Nonnull String tokenName) {
        this.tokenName = tokenName;
    }

    public CreatePersonalToken jwTTokenExpiry(@Nonnull JwTTokenExpiryEnum jwTTokenExpiry) {
        this.jwTTokenExpiry = jwTTokenExpiry;
        return this;
    }

    @Nonnull
    @JsonProperty(value="JWTTokenExpiry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public JwTTokenExpiryEnum getJwTTokenExpiry() {
        return this.jwTTokenExpiry;
    }

    @JsonProperty(value="JWTTokenExpiry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwTTokenExpiry(@Nonnull JwTTokenExpiryEnum jwTTokenExpiry) {
        this.jwTTokenExpiry = jwTTokenExpiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePersonalToken createPersonalToken = (CreatePersonalToken)o;
        return Objects.equals(this.tokenName, createPersonalToken.tokenName) && Objects.equals((Object)this.jwTTokenExpiry, (Object)createPersonalToken.jwTTokenExpiry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tokenName, this.jwTTokenExpiry});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePersonalToken {\n");
        sb.append("    tokenName: ").append(this.toIndentedString(this.tokenName)).append("\n");
        sb.append("    jwTTokenExpiry: ").append(this.toIndentedString((Object)this.jwTTokenExpiry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum JwTTokenExpiryEnum {
        ONE_HOUR(String.valueOf("OneHour")),
        _1(String.valueOf("1")),
        _7(String.valueOf("7")),
        _30(String.valueOf("30")),
        _60(String.valueOf("60")),
        _90(String.valueOf("90")),
        UNLIMITED(String.valueOf("Unlimited"));

        private String value;

        private JwTTokenExpiryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static JwTTokenExpiryEnum fromValue(String value) {
            for (JwTTokenExpiryEnum b : JwTTokenExpiryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

