/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"classification", "parent", "name", "displayName", "description", "style", "associatedTags", "provider", "mutuallyExclusive", "domains", "owners", "lifeCycle", "reviewers", "extension", "tags", "dataProducts"})
public class CreateTag {
    public static final String JSON_PROPERTY_CLASSIFICATION = "classification";
    @Nullable
    private String classification;
    public static final String JSON_PROPERTY_PARENT = "parent";
    @Nullable
    private String parent;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_STYLE = "style";
    @Nullable
    private Style style;
    public static final String JSON_PROPERTY_ASSOCIATED_TAGS = "associatedTags";
    @Nullable
    private List<String> associatedTags = new ArrayList<String>();
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_MUTUALLY_EXCLUSIVE = "mutuallyExclusive";
    @Nullable
    private Boolean mutuallyExclusive;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();

    public CreateTag classification(@Nullable String classification) {
        this.classification = classification;
        return this;
    }

    @Nullable
    @JsonProperty(value="classification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClassification() {
        return this.classification;
    }

    @JsonProperty(value="classification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClassification(@Nullable String classification) {
        this.classification = classification;
    }

    public CreateTag parent(@Nullable String parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParent(@Nullable String parent) {
        this.parent = parent;
    }

    public CreateTag name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateTag displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateTag description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public CreateTag style(@Nullable Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(@Nullable Style style) {
        this.style = style;
    }

    public CreateTag associatedTags(@Nullable List<String> associatedTags) {
        this.associatedTags = associatedTags;
        return this;
    }

    public CreateTag addAssociatedTagsItem(String associatedTagsItem) {
        if (this.associatedTags == null) {
            this.associatedTags = new ArrayList<String>();
        }
        this.associatedTags.add(associatedTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="associatedTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAssociatedTags() {
        return this.associatedTags;
    }

    @JsonProperty(value="associatedTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatedTags(@Nullable List<String> associatedTags) {
        this.associatedTags = associatedTags;
    }

    public CreateTag provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public CreateTag mutuallyExclusive(@Nullable Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
        return this;
    }

    @Nullable
    @JsonProperty(value="mutuallyExclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMutuallyExclusive() {
        return this.mutuallyExclusive;
    }

    @JsonProperty(value="mutuallyExclusive")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMutuallyExclusive(@Nullable Boolean mutuallyExclusive) {
        this.mutuallyExclusive = mutuallyExclusive;
    }

    public CreateTag domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateTag addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateTag owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateTag addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateTag lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateTag reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateTag addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateTag extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateTag tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateTag addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateTag dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateTag addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTag createTag = (CreateTag)o;
        return Objects.equals(this.classification, createTag.classification) && Objects.equals(this.parent, createTag.parent) && Objects.equals(this.name, createTag.name) && Objects.equals(this.displayName, createTag.displayName) && Objects.equals(this.description, createTag.description) && Objects.equals(this.style, createTag.style) && Objects.equals(this.associatedTags, createTag.associatedTags) && Objects.equals((Object)this.provider, (Object)createTag.provider) && Objects.equals(this.mutuallyExclusive, createTag.mutuallyExclusive) && Objects.equals(this.domains, createTag.domains) && Objects.equals(this.owners, createTag.owners) && Objects.equals(this.lifeCycle, createTag.lifeCycle) && Objects.equals(this.reviewers, createTag.reviewers) && Objects.equals(this.extension, createTag.extension) && Objects.equals(this.tags, createTag.tags) && Objects.equals(this.dataProducts, createTag.dataProducts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.classification, this.parent, this.name, this.displayName, this.description, this.style, this.associatedTags, this.provider, this.mutuallyExclusive, this.domains, this.owners, this.lifeCycle, this.reviewers, this.extension, this.tags, this.dataProducts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTag {\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    associatedTags: ").append(this.toIndentedString(this.associatedTags)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    mutuallyExclusive: ").append(this.toIndentedString(this.mutuallyExclusive)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

