/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Profile;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"teamType", "name", "email", "displayName", "externalId", "description", "profile", "parents", "children", "users", "defaultRoles", "owners", "isJoinable", "policies", "domains", "lifeCycle", "reviewers", "extension", "tags", "dataProducts"})
public class CreateTeam {
    public static final String JSON_PROPERTY_TEAM_TYPE = "teamType";
    @Nonnull
    private TeamTypeEnum teamType;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nullable
    private String email;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    @Nullable
    private String externalId;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    @Nullable
    private Profile profile;
    public static final String JSON_PROPERTY_PARENTS = "parents";
    @Nullable
    private List<UUID> parents = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private List<UUID> children = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_USERS = "users";
    @Nullable
    private List<UUID> users = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_DEFAULT_ROLES = "defaultRoles";
    @Nullable
    private List<UUID> defaultRoles = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_IS_JOINABLE = "isJoinable";
    @Nullable
    private Boolean isJoinable;
    public static final String JSON_PROPERTY_POLICIES = "policies";
    @Nullable
    private List<UUID> policies = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<String> dataProducts = new ArrayList<String>();

    public CreateTeam teamType(@Nonnull TeamTypeEnum teamType) {
        this.teamType = teamType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="teamType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TeamTypeEnum getTeamType() {
        return this.teamType;
    }

    @JsonProperty(value="teamType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTeamType(@Nonnull TeamTypeEnum teamType) {
        this.teamType = teamType;
    }

    public CreateTeam name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateTeam email(@Nullable String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public CreateTeam displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CreateTeam externalId(@Nullable String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(@Nullable String externalId) {
        this.externalId = externalId;
    }

    public CreateTeam description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CreateTeam profile(@Nullable Profile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Profile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(@Nullable Profile profile) {
        this.profile = profile;
    }

    public CreateTeam parents(@Nullable List<UUID> parents) {
        this.parents = parents;
        return this;
    }

    public CreateTeam addParentsItem(UUID parentsItem) {
        if (this.parents == null) {
            this.parents = new ArrayList<UUID>();
        }
        this.parents.add(parentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getParents() {
        return this.parents;
    }

    @JsonProperty(value="parents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParents(@Nullable List<UUID> parents) {
        this.parents = parents;
    }

    public CreateTeam children(@Nullable List<UUID> children) {
        this.children = children;
        return this;
    }

    public CreateTeam addChildrenItem(UUID childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<UUID>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable List<UUID> children) {
        this.children = children;
    }

    public CreateTeam users(@Nullable List<UUID> users) {
        this.users = users;
        return this;
    }

    public CreateTeam addUsersItem(UUID usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<UUID>();
        }
        this.users.add(usersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(@Nullable List<UUID> users) {
        this.users = users;
    }

    public CreateTeam defaultRoles(@Nullable List<UUID> defaultRoles) {
        this.defaultRoles = defaultRoles;
        return this;
    }

    public CreateTeam addDefaultRolesItem(UUID defaultRolesItem) {
        if (this.defaultRoles == null) {
            this.defaultRoles = new ArrayList<UUID>();
        }
        this.defaultRoles.add(defaultRolesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultRoles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getDefaultRoles() {
        return this.defaultRoles;
    }

    @JsonProperty(value="defaultRoles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRoles(@Nullable List<UUID> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public CreateTeam owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateTeam addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateTeam isJoinable(@Nullable Boolean isJoinable) {
        this.isJoinable = isJoinable;
        return this;
    }

    @Nullable
    @JsonProperty(value="isJoinable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsJoinable() {
        return this.isJoinable;
    }

    @JsonProperty(value="isJoinable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsJoinable(@Nullable Boolean isJoinable) {
        this.isJoinable = isJoinable;
    }

    public CreateTeam policies(@Nullable List<UUID> policies) {
        this.policies = policies;
        return this;
    }

    public CreateTeam addPoliciesItem(UUID policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<UUID>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicies(@Nullable List<UUID> policies) {
        this.policies = policies;
    }

    public CreateTeam domains(@Nullable List<String> domains) {
        this.domains = domains;
        return this;
    }

    public CreateTeam addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<String> domains) {
        this.domains = domains;
    }

    public CreateTeam lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateTeam reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateTeam addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateTeam extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public CreateTeam tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateTeam addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateTeam dataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateTeam addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTeam createTeam = (CreateTeam)o;
        return Objects.equals((Object)this.teamType, (Object)createTeam.teamType) && Objects.equals(this.name, createTeam.name) && Objects.equals(this.email, createTeam.email) && Objects.equals(this.displayName, createTeam.displayName) && Objects.equals(this.externalId, createTeam.externalId) && Objects.equals(this.description, createTeam.description) && Objects.equals(this.profile, createTeam.profile) && Objects.equals(this.parents, createTeam.parents) && Objects.equals(this.children, createTeam.children) && Objects.equals(this.users, createTeam.users) && Objects.equals(this.defaultRoles, createTeam.defaultRoles) && Objects.equals(this.owners, createTeam.owners) && Objects.equals(this.isJoinable, createTeam.isJoinable) && Objects.equals(this.policies, createTeam.policies) && Objects.equals(this.domains, createTeam.domains) && Objects.equals(this.lifeCycle, createTeam.lifeCycle) && Objects.equals(this.reviewers, createTeam.reviewers) && Objects.equals(this.extension, createTeam.extension) && Objects.equals(this.tags, createTeam.tags) && Objects.equals(this.dataProducts, createTeam.dataProducts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.teamType, this.name, this.email, this.displayName, this.externalId, this.description, this.profile, this.parents, this.children, this.users, this.defaultRoles, this.owners, this.isJoinable, this.policies, this.domains, this.lifeCycle, this.reviewers, this.extension, this.tags, this.dataProducts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTeam {\n");
        sb.append("    teamType: ").append(this.toIndentedString((Object)this.teamType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    parents: ").append(this.toIndentedString(this.parents)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    defaultRoles: ").append(this.toIndentedString(this.defaultRoles)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    isJoinable: ").append(this.toIndentedString(this.isJoinable)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TeamTypeEnum {
        GROUP(String.valueOf("Group")),
        DEPARTMENT(String.valueOf("Department")),
        DIVISION(String.valueOf("Division")),
        BUSINESS_UNIT(String.valueOf("BusinessUnit")),
        ORGANIZATION(String.valueOf("Organization"));

        private String value;

        private TeamTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TeamTypeEnum fromValue(String value) {
            for (TeamTypeEnum b : TeamTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

