/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AnnouncementDetails;
import org.openmetadata.client.model.ChatbotDetails;
import org.openmetadata.client.model.CreateTaskDetails;

@JsonPropertyOrder(value={"message", "from", "addressedTo", "about", "type", "taskDetails", "announcementDetails", "chatbotDetails", "domains"})
public class CreateThread {
    public static final String JSON_PROPERTY_MESSAGE = "message";
    @Nonnull
    private String message;
    public static final String JSON_PROPERTY_FROM = "from";
    @Nonnull
    private String from;
    public static final String JSON_PROPERTY_ADDRESSED_TO = "addressedTo";
    @Nullable
    private String addressedTo;
    public static final String JSON_PROPERTY_ABOUT = "about";
    @Nonnull
    private String about;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private TypeEnum type;
    public static final String JSON_PROPERTY_TASK_DETAILS = "taskDetails";
    @Nullable
    private CreateTaskDetails taskDetails;
    public static final String JSON_PROPERTY_ANNOUNCEMENT_DETAILS = "announcementDetails";
    @Nullable
    private AnnouncementDetails announcementDetails;
    public static final String JSON_PROPERTY_CHATBOT_DETAILS = "chatbotDetails";
    @Nullable
    private ChatbotDetails chatbotDetails;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<UUID> domains = new ArrayList<UUID>();

    public CreateThread message(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    public CreateThread from(@Nonnull String from) {
        this.from = from;
        return this;
    }

    @Nonnull
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFrom(@Nonnull String from) {
        this.from = from;
    }

    public CreateThread addressedTo(@Nullable String addressedTo) {
        this.addressedTo = addressedTo;
        return this;
    }

    @Nullable
    @JsonProperty(value="addressedTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddressedTo() {
        return this.addressedTo;
    }

    @JsonProperty(value="addressedTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddressedTo(@Nullable String addressedTo) {
        this.addressedTo = addressedTo;
    }

    public CreateThread about(@Nonnull String about) {
        this.about = about;
        return this;
    }

    @Nonnull
    @JsonProperty(value="about")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAbout() {
        return this.about;
    }

    @JsonProperty(value="about")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAbout(@Nonnull String about) {
        this.about = about;
    }

    public CreateThread type(@Nullable TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable TypeEnum type) {
        this.type = type;
    }

    public CreateThread taskDetails(@Nullable CreateTaskDetails taskDetails) {
        this.taskDetails = taskDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="taskDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreateTaskDetails getTaskDetails() {
        return this.taskDetails;
    }

    @JsonProperty(value="taskDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskDetails(@Nullable CreateTaskDetails taskDetails) {
        this.taskDetails = taskDetails;
    }

    public CreateThread announcementDetails(@Nullable AnnouncementDetails announcementDetails) {
        this.announcementDetails = announcementDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="announcementDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AnnouncementDetails getAnnouncementDetails() {
        return this.announcementDetails;
    }

    @JsonProperty(value="announcementDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnouncementDetails(@Nullable AnnouncementDetails announcementDetails) {
        this.announcementDetails = announcementDetails;
    }

    public CreateThread chatbotDetails(@Nullable ChatbotDetails chatbotDetails) {
        this.chatbotDetails = chatbotDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="chatbotDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChatbotDetails getChatbotDetails() {
        return this.chatbotDetails;
    }

    @JsonProperty(value="chatbotDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChatbotDetails(@Nullable ChatbotDetails chatbotDetails) {
        this.chatbotDetails = chatbotDetails;
    }

    public CreateThread domains(@Nullable List<UUID> domains) {
        this.domains = domains;
        return this;
    }

    public CreateThread addDomainsItem(UUID domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<UUID>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<UUID> domains) {
        this.domains = domains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateThread createThread = (CreateThread)o;
        return Objects.equals(this.message, createThread.message) && Objects.equals(this.from, createThread.from) && Objects.equals(this.addressedTo, createThread.addressedTo) && Objects.equals(this.about, createThread.about) && Objects.equals((Object)this.type, (Object)createThread.type) && Objects.equals(this.taskDetails, createThread.taskDetails) && Objects.equals(this.announcementDetails, createThread.announcementDetails) && Objects.equals(this.chatbotDetails, createThread.chatbotDetails) && Objects.equals(this.domains, createThread.domains);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.from, this.addressedTo, this.about, this.type, this.taskDetails, this.announcementDetails, this.chatbotDetails, this.domains});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateThread {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    addressedTo: ").append(this.toIndentedString(this.addressedTo)).append("\n");
        sb.append("    about: ").append(this.toIndentedString(this.about)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    taskDetails: ").append(this.toIndentedString(this.taskDetails)).append("\n");
        sb.append("    announcementDetails: ").append(this.toIndentedString(this.announcementDetails)).append("\n");
        sb.append("    chatbotDetails: ").append(this.toIndentedString(this.chatbotDetails)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CONVERSATION(String.valueOf("Conversation")),
        TASK(String.valueOf("Task")),
        ANNOUNCEMENT(String.valueOf("Announcement")),
        CHATBOT(String.valueOf("Chatbot"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

