/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.CustomPropertyConfig;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"name", "displayName", "description", "propertyType", "customPropertyConfig"})
public class CustomProperty {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_PROPERTY_TYPE = "propertyType";
    @Nonnull
    private EntityReference propertyType;
    public static final String JSON_PROPERTY_CUSTOM_PROPERTY_CONFIG = "customPropertyConfig";
    @Nullable
    private CustomPropertyConfig customPropertyConfig;

    public CustomProperty name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CustomProperty displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CustomProperty description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public CustomProperty propertyType(@Nonnull EntityReference propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="propertyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getPropertyType() {
        return this.propertyType;
    }

    @JsonProperty(value="propertyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPropertyType(@Nonnull EntityReference propertyType) {
        this.propertyType = propertyType;
    }

    public CustomProperty customPropertyConfig(@Nullable CustomPropertyConfig customPropertyConfig) {
        this.customPropertyConfig = customPropertyConfig;
        return this;
    }

    @Nullable
    @JsonProperty(value="customPropertyConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomPropertyConfig getCustomPropertyConfig() {
        return this.customPropertyConfig;
    }

    @JsonProperty(value="customPropertyConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomPropertyConfig(@Nullable CustomPropertyConfig customPropertyConfig) {
        this.customPropertyConfig = customPropertyConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomProperty customProperty = (CustomProperty)o;
        return Objects.equals(this.name, customProperty.name) && Objects.equals(this.displayName, customProperty.displayName) && Objects.equals(this.description, customProperty.description) && Objects.equals(this.propertyType, customProperty.propertyType) && Objects.equals(this.customPropertyConfig, customProperty.customPropertyConfig);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.propertyType, this.customPropertyConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomProperty {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    propertyType: ").append(this.toIndentedString(this.propertyType)).append("\n");
        sb.append("    customPropertyConfig: ").append(this.toIndentedString(this.customPropertyConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

