/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"includes", "excludes"})
public class FilterPattern {
    public static final String JSON_PROPERTY_INCLUDES = "includes";
    @Nullable
    private List<String> includes = new ArrayList<String>();
    public static final String JSON_PROPERTY_EXCLUDES = "excludes";
    @Nullable
    private List<String> excludes = new ArrayList<String>();

    public FilterPattern includes(@Nullable List<String> includes) {
        this.includes = includes;
        return this;
    }

    public FilterPattern addIncludesItem(String includesItem) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        this.includes.add(includesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="includes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIncludes() {
        return this.includes;
    }

    @JsonProperty(value="includes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludes(@Nullable List<String> includes) {
        this.includes = includes;
    }

    public FilterPattern excludes(@Nullable List<String> excludes) {
        this.excludes = excludes;
        return this;
    }

    public FilterPattern addExcludesItem(String excludesItem) {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        this.excludes.add(excludesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="excludes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExcludes() {
        return this.excludes;
    }

    @JsonProperty(value="excludes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludes(@Nullable List<String> excludes) {
        this.excludes = excludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterPattern filterPattern = (FilterPattern)o;
        return Objects.equals(this.includes, filterPattern.includes) && Objects.equals(this.excludes, filterPattern.excludes);
    }

    public int hashCode() {
        return Objects.hash(this.includes, this.excludes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterPattern {\n");
        sb.append("    includes: ").append(this.toIndentedString(this.includes)).append("\n");
        sb.append("    excludes: ").append(this.toIndentedString(this.excludes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

