/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ColumnLineage;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"sqlQuery", "columnsLineage", "pipeline", "description", "source", "createdAt", "createdBy", "updatedAt", "updatedBy", "assetEdges"})
public class LineageDetails {
    public static final String JSON_PROPERTY_SQL_QUERY = "sqlQuery";
    @Nullable
    private String sqlQuery;
    public static final String JSON_PROPERTY_COLUMNS_LINEAGE = "columnsLineage";
    @Nullable
    private List<ColumnLineage> columnsLineage = new ArrayList<ColumnLineage>();
    public static final String JSON_PROPERTY_PIPELINE = "pipeline";
    @Nullable
    private EntityReference pipeline;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_SOURCE = "source";
    @Nullable
    private SourceEnum source;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    @Nullable
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    @Nullable
    private String createdBy;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    @Nullable
    private String updatedBy;
    public static final String JSON_PROPERTY_ASSET_EDGES = "assetEdges";
    @Nullable
    private Integer assetEdges;

    public LineageDetails sqlQuery(@Nullable String sqlQuery) {
        this.sqlQuery = sqlQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="sqlQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    @JsonProperty(value="sqlQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSqlQuery(@Nullable String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public LineageDetails columnsLineage(@Nullable List<ColumnLineage> columnsLineage) {
        this.columnsLineage = columnsLineage;
        return this;
    }

    public LineageDetails addColumnsLineageItem(ColumnLineage columnsLineageItem) {
        if (this.columnsLineage == null) {
            this.columnsLineage = new ArrayList<ColumnLineage>();
        }
        this.columnsLineage.add(columnsLineageItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columnsLineage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ColumnLineage> getColumnsLineage() {
        return this.columnsLineage;
    }

    @JsonProperty(value="columnsLineage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumnsLineage(@Nullable List<ColumnLineage> columnsLineage) {
        this.columnsLineage = columnsLineage;
    }

    public LineageDetails pipeline(@Nullable EntityReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Nullable
    @JsonProperty(value="pipeline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getPipeline() {
        return this.pipeline;
    }

    @JsonProperty(value="pipeline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipeline(@Nullable EntityReference pipeline) {
        this.pipeline = pipeline;
    }

    public LineageDetails description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public LineageDetails source(@Nullable SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(@Nullable SourceEnum source) {
        this.source = source;
    }

    public LineageDetails createdAt(@Nullable Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(@Nullable Long createdAt) {
        this.createdAt = createdAt;
    }

    public LineageDetails createdBy(@Nullable String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(@Nullable String createdBy) {
        this.createdBy = createdBy;
    }

    public LineageDetails updatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public LineageDetails updatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public LineageDetails assetEdges(@Nullable Integer assetEdges) {
        this.assetEdges = assetEdges;
        return this;
    }

    @Nullable
    @JsonProperty(value="assetEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAssetEdges() {
        return this.assetEdges;
    }

    @JsonProperty(value="assetEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetEdges(@Nullable Integer assetEdges) {
        this.assetEdges = assetEdges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineageDetails lineageDetails = (LineageDetails)o;
        return Objects.equals(this.sqlQuery, lineageDetails.sqlQuery) && Objects.equals(this.columnsLineage, lineageDetails.columnsLineage) && Objects.equals(this.pipeline, lineageDetails.pipeline) && Objects.equals(this.description, lineageDetails.description) && Objects.equals((Object)this.source, (Object)lineageDetails.source) && Objects.equals(this.createdAt, lineageDetails.createdAt) && Objects.equals(this.createdBy, lineageDetails.createdBy) && Objects.equals(this.updatedAt, lineageDetails.updatedAt) && Objects.equals(this.updatedBy, lineageDetails.updatedBy) && Objects.equals(this.assetEdges, lineageDetails.assetEdges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sqlQuery, this.columnsLineage, this.pipeline, this.description, this.source, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.assetEdges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineageDetails {\n");
        sb.append("    sqlQuery: ").append(this.toIndentedString(this.sqlQuery)).append("\n");
        sb.append("    columnsLineage: ").append(this.toIndentedString(this.columnsLineage)).append("\n");
        sb.append("    pipeline: ").append(this.toIndentedString(this.pipeline)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    assetEdges: ").append(this.toIndentedString(this.assetEdges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        MANUAL(String.valueOf("Manual")),
        VIEW_LINEAGE(String.valueOf("ViewLineage")),
        QUERY_LINEAGE(String.valueOf("QueryLineage")),
        PIPELINE_LINEAGE(String.valueOf("PipelineLineage")),
        DASHBOARD_LINEAGE(String.valueOf("DashboardLineage")),
        DBT_LINEAGE(String.valueOf("DbtLineage")),
        SPARK_LINEAGE(String.valueOf("SparkLineage")),
        OPEN_LINEAGE(String.valueOf("OpenLineage")),
        EXTERNAL_TABLE_LINEAGE(String.valueOf("ExternalTableLineage")),
        CROSS_DATABASE_LINEAGE(String.valueOf("CrossDatabaseLineage")),
        CHILD_ASSETS(String.valueOf("ChildAssets"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

