/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "subtype", "parameters", "wildcardType", "wildcardSubtype"})
public class MediaType {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private String type;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    @Nullable
    private String subtype;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    @Nullable
    private Map<String, String> parameters = new HashMap<String, String>();
    public static final String JSON_PROPERTY_WILDCARD_TYPE = "wildcardType";
    @Nullable
    private Boolean wildcardType;
    public static final String JSON_PROPERTY_WILDCARD_SUBTYPE = "wildcardSubtype";
    @Nullable
    private Boolean wildcardSubtype;

    public MediaType type(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable String type) {
        this.type = type;
    }

    public MediaType subtype(@Nullable String subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubtype() {
        return this.subtype;
    }

    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubtype(@Nullable String subtype) {
        this.subtype = subtype;
    }

    public MediaType parameters(@Nullable Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public MediaType putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameters(@Nullable Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public MediaType wildcardType(@Nullable Boolean wildcardType) {
        this.wildcardType = wildcardType;
        return this;
    }

    @Nullable
    @JsonProperty(value="wildcardType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getWildcardType() {
        return this.wildcardType;
    }

    @JsonProperty(value="wildcardType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWildcardType(@Nullable Boolean wildcardType) {
        this.wildcardType = wildcardType;
    }

    public MediaType wildcardSubtype(@Nullable Boolean wildcardSubtype) {
        this.wildcardSubtype = wildcardSubtype;
        return this;
    }

    @Nullable
    @JsonProperty(value="wildcardSubtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getWildcardSubtype() {
        return this.wildcardSubtype;
    }

    @JsonProperty(value="wildcardSubtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWildcardSubtype(@Nullable Boolean wildcardSubtype) {
        this.wildcardSubtype = wildcardSubtype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return Objects.equals(this.type, mediaType.type) && Objects.equals(this.subtype, mediaType.subtype) && Objects.equals(this.parameters, mediaType.parameters) && Objects.equals(this.wildcardType, mediaType.wildcardType) && Objects.equals(this.wildcardSubtype, mediaType.wildcardSubtype);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.parameters, this.wildcardType, this.wildcardSubtype);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaType {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    wildcardType: ").append(this.toIndentedString(this.wildcardType)).append("\n");
        sb.append("    wildcardSubtype: ").append(this.toIndentedString(this.wildcardSubtype)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

