/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Reaction;

@JsonPropertyOrder(value={"id", "message", "postTs", "from", "reactions"})
public class Post {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    @Nonnull
    private String message;
    public static final String JSON_PROPERTY_POST_TS = "postTs";
    @Nullable
    private Long postTs;
    public static final String JSON_PROPERTY_FROM = "from";
    @Nonnull
    private String from;
    public static final String JSON_PROPERTY_REACTIONS = "reactions";
    @Nullable
    private List<Reaction> reactions = new ArrayList<Reaction>();

    public Post id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public Post message(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    public Post postTs(@Nullable Long postTs) {
        this.postTs = postTs;
        return this;
    }

    @Nullable
    @JsonProperty(value="postTs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPostTs() {
        return this.postTs;
    }

    @JsonProperty(value="postTs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostTs(@Nullable Long postTs) {
        this.postTs = postTs;
    }

    public Post from(@Nonnull String from) {
        this.from = from;
        return this;
    }

    @Nonnull
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFrom(@Nonnull String from) {
        this.from = from;
    }

    public Post reactions(@Nullable List<Reaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    public Post addReactionsItem(Reaction reactionsItem) {
        if (this.reactions == null) {
            this.reactions = new ArrayList<Reaction>();
        }
        this.reactions.add(reactionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reactions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Reaction> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="reactions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReactions(@Nullable List<Reaction> reactions) {
        this.reactions = reactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Post post = (Post)o;
        return Objects.equals(this.id, post.id) && Objects.equals(this.message, post.message) && Objects.equals(this.postTs, post.postTs) && Objects.equals(this.from, post.from) && Objects.equals(this.reactions, post.reactions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.message, this.postTs, this.from, this.reactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Post {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    postTs: ").append(this.toIndentedString(this.postTs)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    reactions: ").append(this.toIndentedString(this.reactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

