/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "operations"})
public class ResourceDescriptor {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    @Nullable
    private List<OperationsEnum> operations = new ArrayList<OperationsEnum>();

    public ResourceDescriptor name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public ResourceDescriptor operations(@Nullable List<OperationsEnum> operations) {
        this.operations = operations;
        return this;
    }

    public ResourceDescriptor addOperationsItem(OperationsEnum operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationsEnum>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OperationsEnum> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperations(@Nullable List<OperationsEnum> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceDescriptor resourceDescriptor = (ResourceDescriptor)o;
        return Objects.equals(this.name, resourceDescriptor.name) && Objects.equals(this.operations, resourceDescriptor.operations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceDescriptor {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationsEnum {
        ALL(String.valueOf("All")),
        CREATE(String.valueOf("Create")),
        CREATE_INGESTION_PIPELINE_AUTOMATOR(String.valueOf("CreateIngestionPipelineAutomator")),
        DELETE(String.valueOf("Delete")),
        VIEW_ALL(String.valueOf("ViewAll")),
        VIEW_BASIC(String.valueOf("ViewBasic")),
        VIEW_USAGE(String.valueOf("ViewUsage")),
        VIEW_TESTS(String.valueOf("ViewTests")),
        VIEW_QUERIES(String.valueOf("ViewQueries")),
        VIEW_DATA_PROFILE(String.valueOf("ViewDataProfile")),
        VIEW_PROFILER_GLOBAL_CONFIGURATION(String.valueOf("ViewProfilerGlobalConfiguration")),
        VIEW_SAMPLE_DATA(String.valueOf("ViewSampleData")),
        VIEW_TEST_CASE_FAILED_ROWS_SAMPLE(String.valueOf("ViewTestCaseFailedRowsSample")),
        EDIT_ALL(String.valueOf("EditAll")),
        EDIT_CUSTOM_FIELDS(String.valueOf("EditCustomFields")),
        EDIT_DATA_PROFILE(String.valueOf("EditDataProfile")),
        EDIT_DESCRIPTION(String.valueOf("EditDescription")),
        EDIT_DISPLAY_NAME(String.valueOf("EditDisplayName")),
        EDIT_LINEAGE(String.valueOf("EditLineage")),
        EDIT_ENTITY_RELATIONSHIP(String.valueOf("EditEntityRelationship")),
        EDIT_POLICY(String.valueOf("EditPolicy")),
        EDIT_OWNERS(String.valueOf("EditOwners")),
        EDIT_QUERIES(String.valueOf("EditQueries")),
        EDIT_REVIEWERS(String.valueOf("EditReviewers")),
        EDIT_ROLE(String.valueOf("EditRole")),
        EDIT_SAMPLE_DATA(String.valueOf("EditSampleData")),
        EDIT_STATUS(String.valueOf("EditStatus")),
        EDIT_TAGS(String.valueOf("EditTags")),
        EDIT_GLOSSARY_TERMS(String.valueOf("EditGlossaryTerms")),
        EDIT_TEAMS(String.valueOf("EditTeams")),
        EDIT_TIER(String.valueOf("EditTier")),
        EDIT_CERTIFICATION(String.valueOf("EditCertification")),
        EDIT_TESTS(String.valueOf("EditTests")),
        EDIT_USAGE(String.valueOf("EditUsage")),
        EDIT_USERS(String.valueOf("EditUsers")),
        EDIT_LIFE_CYCLE(String.valueOf("EditLifeCycle")),
        EDIT_KNOWLEDGE_PANEL(String.valueOf("EditKnowledgePanel")),
        EDIT_PAGE(String.valueOf("EditPage")),
        EDIT_INGESTION_PIPELINE_STATUS(String.valueOf("EditIngestionPipelineStatus")),
        DELETE_TEST_CASE_FAILED_ROWS_SAMPLE(String.valueOf("DeleteTestCaseFailedRowsSample")),
        DEPLOY(String.valueOf("Deploy")),
        TRIGGER(String.valueOf("Trigger")),
        KILL(String.valueOf("Kill")),
        GENERATE_TOKEN(String.valueOf("GenerateToken")),
        EDIT_SCIM(String.valueOf("EditScim")),
        CREATE_SCIM(String.valueOf("CreateScim")),
        DELETE_SCIM(String.valueOf("DeleteScim")),
        VIEW_SCIM(String.valueOf("ViewScim"));

        private String value;

        private OperationsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationsEnum fromValue(String value) {
            for (OperationsEnum b : OperationsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

