/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityTag;
import org.openmetadata.client.model.Link;
import org.openmetadata.client.model.MediaType;
import org.openmetadata.client.model.NewCookie;
import org.openmetadata.client.model.ResponseHeaders;
import org.openmetadata.client.model.ResponseLanguage;
import org.openmetadata.client.model.ResponseStringHeaders;
import org.openmetadata.client.model.StatusType;

@JsonPropertyOrder(value={"statusInfo", "allowedMethods", "stringHeaders", "closed", "length", "location", "language", "date", "lastModified", "headers", "status", "metadata", "entity", "cookies", "mediaType", "links", "entityTag"})
public class Response {
    public static final String JSON_PROPERTY_STATUS_INFO = "statusInfo";
    @Nullable
    private StatusType statusInfo;
    public static final String JSON_PROPERTY_ALLOWED_METHODS = "allowedMethods";
    @Nullable
    private Set<String> allowedMethods = new LinkedHashSet<String>();
    public static final String JSON_PROPERTY_STRING_HEADERS = "stringHeaders";
    @Nullable
    private ResponseStringHeaders stringHeaders;
    public static final String JSON_PROPERTY_CLOSED = "closed";
    @Nullable
    private Boolean closed;
    public static final String JSON_PROPERTY_LENGTH = "length";
    @Nullable
    private Integer length;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nullable
    private URI location;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @Nullable
    private ResponseLanguage language;
    public static final String JSON_PROPERTY_DATE = "date";
    @Nullable
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_LAST_MODIFIED = "lastModified";
    @Nullable
    private OffsetDateTime lastModified;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    @Nullable
    private ResponseHeaders headers;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private Integer status;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private ResponseHeaders metadata;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    @Nullable
    private Object entity;
    public static final String JSON_PROPERTY_COOKIES = "cookies";
    @Nullable
    private Map<String, NewCookie> cookies = new HashMap<String, NewCookie>();
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    @Nullable
    private MediaType mediaType;
    public static final String JSON_PROPERTY_LINKS = "links";
    @Nullable
    private Set<Link> links = new LinkedHashSet<Link>();
    public static final String JSON_PROPERTY_ENTITY_TAG = "entityTag";
    @Nullable
    private EntityTag entityTag;

    public Response statusInfo(@Nullable StatusType statusInfo) {
        this.statusInfo = statusInfo;
        return this;
    }

    @Nullable
    @JsonProperty(value="statusInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusType getStatusInfo() {
        return this.statusInfo;
    }

    @JsonProperty(value="statusInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusInfo(@Nullable StatusType statusInfo) {
        this.statusInfo = statusInfo;
    }

    public Response allowedMethods(@Nullable Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public Response addAllowedMethodsItem(String allowedMethodsItem) {
        if (this.allowedMethods == null) {
            this.allowedMethods = new LinkedHashSet<String>();
        }
        this.allowedMethods.add(allowedMethodsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="allowedMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="allowedMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedMethods(@Nullable Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public Response stringHeaders(@Nullable ResponseStringHeaders stringHeaders) {
        this.stringHeaders = stringHeaders;
        return this;
    }

    @Nullable
    @JsonProperty(value="stringHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseStringHeaders getStringHeaders() {
        return this.stringHeaders;
    }

    @JsonProperty(value="stringHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStringHeaders(@Nullable ResponseStringHeaders stringHeaders) {
        this.stringHeaders = stringHeaders;
    }

    public Response closed(@Nullable Boolean closed) {
        this.closed = closed;
        return this;
    }

    @Nullable
    @JsonProperty(value="closed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getClosed() {
        return this.closed;
    }

    @JsonProperty(value="closed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClosed(@Nullable Boolean closed) {
        this.closed = closed;
    }

    public Response length(@Nullable Integer length) {
        this.length = length;
        return this;
    }

    @Nullable
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLength(@Nullable Integer length) {
        this.length = length;
    }

    public Response location(@Nullable URI location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(@Nullable URI location) {
        this.location = location;
    }

    public Response language(@Nullable ResponseLanguage language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseLanguage getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(@Nullable ResponseLanguage language) {
        this.language = language;
    }

    public Response date(@Nullable OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDate(@Nullable OffsetDateTime date) {
        this.date = date;
    }

    public Response lastModified(@Nullable OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    @JsonProperty(value="lastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="lastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastModified(@Nullable OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public Response headers(@Nullable ResponseHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseHeaders getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(@Nullable ResponseHeaders headers) {
        this.headers = headers;
    }

    public Response status(@Nullable Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(@Nullable Integer status) {
        this.status = status;
    }

    public Response metadata(@Nullable ResponseHeaders metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseHeaders getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable ResponseHeaders metadata) {
        this.metadata = metadata;
    }

    public Response entity(@Nullable Object entity) {
        this.entity = entity;
        return this;
    }

    @Nullable
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntity(@Nullable Object entity) {
        this.entity = entity;
    }

    public Response cookies(@Nullable Map<String, NewCookie> cookies) {
        this.cookies = cookies;
        return this;
    }

    public Response putCookiesItem(String key, NewCookie cookiesItem) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, NewCookie>();
        }
        this.cookies.put(key, cookiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="cookies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, NewCookie> getCookies() {
        return this.cookies;
    }

    @JsonProperty(value="cookies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCookies(@Nullable Map<String, NewCookie> cookies) {
        this.cookies = cookies;
    }

    public Response mediaType(@Nullable MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMediaType(@Nullable MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public Response links(@Nullable Set<Link> links) {
        this.links = links;
        return this;
    }

    public Response addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new LinkedHashSet<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<Link> getLinks() {
        return this.links;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(@Nullable Set<Link> links) {
        this.links = links;
    }

    public Response entityTag(@Nullable EntityTag entityTag) {
        this.entityTag = entityTag;
        return this;
    }

    @Nullable
    @JsonProperty(value="entityTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityTag getEntityTag() {
        return this.entityTag;
    }

    @JsonProperty(value="entityTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityTag(@Nullable EntityTag entityTag) {
        this.entityTag = entityTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.statusInfo, response.statusInfo) && Objects.equals(this.allowedMethods, response.allowedMethods) && Objects.equals(this.stringHeaders, response.stringHeaders) && Objects.equals(this.closed, response.closed) && Objects.equals(this.length, response.length) && Objects.equals(this.location, response.location) && Objects.equals(this.language, response.language) && Objects.equals(this.date, response.date) && Objects.equals(this.lastModified, response.lastModified) && Objects.equals(this.headers, response.headers) && Objects.equals(this.status, response.status) && Objects.equals(this.metadata, response.metadata) && Objects.equals(this.entity, response.entity) && Objects.equals(this.cookies, response.cookies) && Objects.equals(this.mediaType, response.mediaType) && Objects.equals(this.links, response.links) && Objects.equals(this.entityTag, response.entityTag);
    }

    public int hashCode() {
        return Objects.hash(this.statusInfo, this.allowedMethods, this.stringHeaders, this.closed, this.length, this.location, this.language, this.date, this.lastModified, this.headers, this.status, this.metadata, this.entity, this.cookies, this.mediaType, this.links, this.entityTag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Response {\n");
        sb.append("    statusInfo: ").append(this.toIndentedString(this.statusInfo)).append("\n");
        sb.append("    allowedMethods: ").append(this.toIndentedString(this.allowedMethods)).append("\n");
        sb.append("    stringHeaders: ").append(this.toIndentedString(this.stringHeaders)).append("\n");
        sb.append("    closed: ").append(this.toIndentedString(this.closed)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    cookies: ").append(this.toIndentedString(this.cookies)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    entityTag: ").append(this.toIndentedString(this.entityTag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

