/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.PolicyInfo;

@JsonPropertyOrder(value={"role", "policies", "inheritedFrom", "defaultRole"})
public class RolePermission {
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nullable
    private EntityReference role;
    public static final String JSON_PROPERTY_POLICIES = "policies";
    @Nullable
    private List<PolicyInfo> policies = new ArrayList<PolicyInfo>();
    public static final String JSON_PROPERTY_INHERITED_FROM = "inheritedFrom";
    @Nullable
    private String inheritedFrom;
    public static final String JSON_PROPERTY_DEFAULT_ROLE = "defaultRole";
    @Nullable
    private Boolean defaultRole;

    public RolePermission role(@Nullable EntityReference role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(@Nullable EntityReference role) {
        this.role = role;
    }

    public RolePermission policies(@Nullable List<PolicyInfo> policies) {
        this.policies = policies;
        return this;
    }

    public RolePermission addPoliciesItem(PolicyInfo policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<PolicyInfo>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PolicyInfo> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicies(@Nullable List<PolicyInfo> policies) {
        this.policies = policies;
    }

    public RolePermission inheritedFrom(@Nullable String inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
        return this;
    }

    @Nullable
    @JsonProperty(value="inheritedFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    @JsonProperty(value="inheritedFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInheritedFrom(@Nullable String inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    public RolePermission defaultRole(@Nullable Boolean defaultRole) {
        this.defaultRole = defaultRole;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultRole")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDefaultRole() {
        return this.defaultRole;
    }

    @JsonProperty(value="defaultRole")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRole(@Nullable Boolean defaultRole) {
        this.defaultRole = defaultRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolePermission rolePermission = (RolePermission)o;
        return Objects.equals(this.role, rolePermission.role) && Objects.equals(this.policies, rolePermission.policies) && Objects.equals(this.inheritedFrom, rolePermission.inheritedFrom) && Objects.equals(this.defaultRole, rolePermission.defaultRole);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.policies, this.inheritedFrom, this.defaultRole);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RolePermission {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    inheritedFrom: ").append(this.toIndentedString(this.inheritedFrom)).append("\n");
        sb.append("    defaultRole: ").append(this.toIndentedString(this.defaultRole)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

