/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "fullyQualifiedName", "description", "effect", "operations", "resources", "condition"})
public class Rule {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    @Nullable
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_EFFECT = "effect";
    @Nonnull
    private EffectEnum effect;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    @Nonnull
    private List<OperationsEnum> operations = new ArrayList<OperationsEnum>();
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    @Nonnull
    private List<String> resources = new ArrayList<String>();
    public static final String JSON_PROPERTY_CONDITION = "condition";
    @Nullable
    private String condition;

    public Rule name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Rule fullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Rule description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Rule effect(@Nonnull EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @Nonnull
    @JsonProperty(value="effect")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EffectEnum getEffect() {
        return this.effect;
    }

    @JsonProperty(value="effect")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEffect(@Nonnull EffectEnum effect) {
        this.effect = effect;
    }

    public Rule operations(@Nonnull List<OperationsEnum> operations) {
        this.operations = operations;
        return this;
    }

    public Rule addOperationsItem(OperationsEnum operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationsEnum>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OperationsEnum> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperations(@Nonnull List<OperationsEnum> operations) {
        this.operations = operations;
    }

    public Rule resources(@Nonnull List<String> resources) {
        this.resources = resources;
        return this;
    }

    public Rule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResources(@Nonnull List<String> resources) {
        this.resources = resources;
    }

    public Rule condition(@Nullable String condition) {
        this.condition = condition;
        return this;
    }

    @Nullable
    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCondition(@Nullable String condition) {
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.name, rule.name) && Objects.equals(this.fullyQualifiedName, rule.fullyQualifiedName) && Objects.equals(this.description, rule.description) && Objects.equals((Object)this.effect, (Object)rule.effect) && Objects.equals(this.operations, rule.operations) && Objects.equals(this.resources, rule.resources) && Objects.equals(this.condition, rule.condition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.fullyQualifiedName, this.description, this.effect, this.operations, this.resources, this.condition});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rule {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EffectEnum {
        ALLOW(String.valueOf("allow")),
        DENY(String.valueOf("deny"));

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectEnum fromValue(String value) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OperationsEnum {
        ALL(String.valueOf("All")),
        CREATE(String.valueOf("Create")),
        CREATE_INGESTION_PIPELINE_AUTOMATOR(String.valueOf("CreateIngestionPipelineAutomator")),
        DELETE(String.valueOf("Delete")),
        VIEW_ALL(String.valueOf("ViewAll")),
        VIEW_BASIC(String.valueOf("ViewBasic")),
        VIEW_USAGE(String.valueOf("ViewUsage")),
        VIEW_TESTS(String.valueOf("ViewTests")),
        VIEW_QUERIES(String.valueOf("ViewQueries")),
        VIEW_DATA_PROFILE(String.valueOf("ViewDataProfile")),
        VIEW_PROFILER_GLOBAL_CONFIGURATION(String.valueOf("ViewProfilerGlobalConfiguration")),
        VIEW_SAMPLE_DATA(String.valueOf("ViewSampleData")),
        VIEW_TEST_CASE_FAILED_ROWS_SAMPLE(String.valueOf("ViewTestCaseFailedRowsSample")),
        EDIT_ALL(String.valueOf("EditAll")),
        EDIT_CUSTOM_FIELDS(String.valueOf("EditCustomFields")),
        EDIT_DATA_PROFILE(String.valueOf("EditDataProfile")),
        EDIT_DESCRIPTION(String.valueOf("EditDescription")),
        EDIT_DISPLAY_NAME(String.valueOf("EditDisplayName")),
        EDIT_LINEAGE(String.valueOf("EditLineage")),
        EDIT_ENTITY_RELATIONSHIP(String.valueOf("EditEntityRelationship")),
        EDIT_POLICY(String.valueOf("EditPolicy")),
        EDIT_OWNERS(String.valueOf("EditOwners")),
        EDIT_QUERIES(String.valueOf("EditQueries")),
        EDIT_REVIEWERS(String.valueOf("EditReviewers")),
        EDIT_ROLE(String.valueOf("EditRole")),
        EDIT_SAMPLE_DATA(String.valueOf("EditSampleData")),
        EDIT_STATUS(String.valueOf("EditStatus")),
        EDIT_TAGS(String.valueOf("EditTags")),
        EDIT_GLOSSARY_TERMS(String.valueOf("EditGlossaryTerms")),
        EDIT_TEAMS(String.valueOf("EditTeams")),
        EDIT_TIER(String.valueOf("EditTier")),
        EDIT_CERTIFICATION(String.valueOf("EditCertification")),
        EDIT_TESTS(String.valueOf("EditTests")),
        EDIT_USAGE(String.valueOf("EditUsage")),
        EDIT_USERS(String.valueOf("EditUsers")),
        EDIT_LIFE_CYCLE(String.valueOf("EditLifeCycle")),
        EDIT_KNOWLEDGE_PANEL(String.valueOf("EditKnowledgePanel")),
        EDIT_PAGE(String.valueOf("EditPage")),
        EDIT_INGESTION_PIPELINE_STATUS(String.valueOf("EditIngestionPipelineStatus")),
        DELETE_TEST_CASE_FAILED_ROWS_SAMPLE(String.valueOf("DeleteTestCaseFailedRowsSample")),
        DEPLOY(String.valueOf("Deploy")),
        TRIGGER(String.valueOf("Trigger")),
        KILL(String.valueOf("Kill")),
        GENERATE_TOKEN(String.valueOf("GenerateToken")),
        EDIT_SCIM(String.valueOf("EditScim")),
        CREATE_SCIM(String.valueOf("CreateScim")),
        DELETE_SCIM(String.valueOf("DeleteScim")),
        VIEW_SCIM(String.valueOf("ViewScim"));

        private String value;

        private OperationsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationsEnum fromValue(String value) {
            for (OperationsEnum b : OperationsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

