/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"name", "displayName", "dataType", "dataTypeDisplay", "description", "fullyQualifiedName", "tags", "children"})
public class SearchIndexField {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_DATA_TYPE = "dataType";
    @Nonnull
    private DataTypeEnum dataType;
    public static final String JSON_PROPERTY_DATA_TYPE_DISPLAY = "dataTypeDisplay";
    @Nullable
    private String dataTypeDisplay;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    @Nullable
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private List<SearchIndexField> children = new ArrayList<SearchIndexField>();

    public SearchIndexField name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SearchIndexField displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public SearchIndexField dataType(@Nonnull DataTypeEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDataType(@Nonnull DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public SearchIndexField dataTypeDisplay(@Nullable String dataTypeDisplay) {
        this.dataTypeDisplay = dataTypeDisplay;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataTypeDisplay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDataTypeDisplay() {
        return this.dataTypeDisplay;
    }

    @JsonProperty(value="dataTypeDisplay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataTypeDisplay(@Nullable String dataTypeDisplay) {
        this.dataTypeDisplay = dataTypeDisplay;
    }

    public SearchIndexField description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public SearchIndexField fullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public SearchIndexField tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public SearchIndexField addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public SearchIndexField children(@Nullable List<SearchIndexField> children) {
        this.children = children;
        return this;
    }

    public SearchIndexField addChildrenItem(SearchIndexField childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<SearchIndexField>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SearchIndexField> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable List<SearchIndexField> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchIndexField searchIndexField = (SearchIndexField)o;
        return Objects.equals(this.name, searchIndexField.name) && Objects.equals(this.displayName, searchIndexField.displayName) && Objects.equals((Object)this.dataType, (Object)searchIndexField.dataType) && Objects.equals(this.dataTypeDisplay, searchIndexField.dataTypeDisplay) && Objects.equals(this.description, searchIndexField.description) && Objects.equals(this.fullyQualifiedName, searchIndexField.fullyQualifiedName) && Objects.equals(this.tags, searchIndexField.tags) && Objects.equals(this.children, searchIndexField.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.dataType, this.dataTypeDisplay, this.description, this.fullyQualifiedName, this.tags, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchIndexField {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString((Object)this.dataType)).append("\n");
        sb.append("    dataTypeDisplay: ").append(this.toIndentedString(this.dataTypeDisplay)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DataTypeEnum {
        NUMBER(String.valueOf("NUMBER")),
        TEXT(String.valueOf("TEXT")),
        BINARY(String.valueOf("BINARY")),
        TIMESTAMP(String.valueOf("TIMESTAMP")),
        TIMESTAMPZ(String.valueOf("TIMESTAMPZ")),
        TIME(String.valueOf("TIME")),
        DATE(String.valueOf("DATE")),
        DATETIME(String.valueOf("DATETIME")),
        KEYWORD(String.valueOf("KEYWORD")),
        ARRAY(String.valueOf("ARRAY")),
        OBJECT(String.valueOf("OBJECT")),
        FLATTENED(String.valueOf("FLATTENED")),
        NESTED(String.valueOf("NESTED")),
        JOIN(String.valueOf("JOIN")),
        RANGE(String.valueOf("RANGE")),
        IP(String.valueOf("IP")),
        VERSION(String.valueOf("VERSION")),
        MURMUR3(String.valueOf("MURMUR3")),
        AGGREGATE_METRIC_DOUBLE(String.valueOf("AGGREGATE_METRIC_DOUBLE")),
        HISTOGRAM(String.valueOf("HISTOGRAM")),
        ANNOTATED_TEXT(String.valueOf("ANNOTATED-TEXT")),
        COMPLETION(String.valueOf("COMPLETION")),
        SEARCH_AS_YOU_TYPE(String.valueOf("SEARCH_AS_YOU_TYPE")),
        DENSE_VECTOR(String.valueOf("DENSE_VECTOR")),
        RANK_FEATURE(String.valueOf("RANK_FEATURE")),
        RANK_FEATURES(String.valueOf("RANK_FEATURES")),
        GEO_POINT(String.valueOf("GEO_POINT")),
        GEO_SHAPE(String.valueOf("GEO_SHAPE")),
        POINT(String.valueOf("POINT")),
        SHAPE(String.valueOf("SHAPE")),
        PERCOLATOR(String.valueOf("PERCOLATOR")),
        BOOLEAN(String.valueOf("BOOLEAN")),
        CONSTANT_KEYWORD(String.valueOf("CONSTANT_KEYWORD")),
        WILDCARD(String.valueOf("WILDCARD")),
        LONG(String.valueOf("LONG")),
        INTEGER(String.valueOf("INTEGER")),
        SHORT(String.valueOf("SHORT")),
        BYTE(String.valueOf("BYTE")),
        DOUBLE(String.valueOf("DOUBLE")),
        FLOAT(String.valueOf("FLOAT")),
        HALF_FLOAT(String.valueOf("HALF_FLOAT")),
        SCALED_FLOAT(String.valueOf("SCALED_FLOAT")),
        UNSIGNED_LONG(String.valueOf("UNSIGNED_LONG")),
        UNKNOWN(String.valueOf("UNKNOWN"));

        private String value;

        private DataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DataTypeEnum fromValue(String value) {
            for (DataTypeEnum b : DataTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

