/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "description", "rule", "enabled", "entityType", "ignoredEntities", "provider"})
public class SemanticsRule {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_RULE = "rule";
    @Nonnull
    private String rule;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    @Nonnull
    private Boolean enabled;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    @Nullable
    private String entityType;
    public static final String JSON_PROPERTY_IGNORED_ENTITIES = "ignoredEntities";
    @Nullable
    private List<String> ignoredEntities = new ArrayList<String>();
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;

    public SemanticsRule name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SemanticsRule description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public SemanticsRule rule(@Nonnull String rule) {
        this.rule = rule;
        return this;
    }

    @Nonnull
    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRule() {
        return this.rule;
    }

    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRule(@Nonnull String rule) {
        this.rule = rule;
    }

    public SemanticsRule enabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(@Nonnull Boolean enabled) {
        this.enabled = enabled;
    }

    public SemanticsRule entityType(@Nullable String entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nullable
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(@Nullable String entityType) {
        this.entityType = entityType;
    }

    public SemanticsRule ignoredEntities(@Nullable List<String> ignoredEntities) {
        this.ignoredEntities = ignoredEntities;
        return this;
    }

    public SemanticsRule addIgnoredEntitiesItem(String ignoredEntitiesItem) {
        if (this.ignoredEntities == null) {
            this.ignoredEntities = new ArrayList<String>();
        }
        this.ignoredEntities.add(ignoredEntitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="ignoredEntities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIgnoredEntities() {
        return this.ignoredEntities;
    }

    @JsonProperty(value="ignoredEntities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIgnoredEntities(@Nullable List<String> ignoredEntities) {
        this.ignoredEntities = ignoredEntities;
    }

    public SemanticsRule provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticsRule semanticsRule = (SemanticsRule)o;
        return Objects.equals(this.name, semanticsRule.name) && Objects.equals(this.description, semanticsRule.description) && Objects.equals(this.rule, semanticsRule.rule) && Objects.equals(this.enabled, semanticsRule.enabled) && Objects.equals(this.entityType, semanticsRule.entityType) && Objects.equals(this.ignoredEntities, semanticsRule.ignoredEntities) && Objects.equals((Object)this.provider, (Object)semanticsRule.provider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.rule, this.enabled, this.entityType, this.ignoredEntities, this.provider});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SemanticsRule {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    ignoredEntities: ").append(this.toIndentedString(this.ignoredEntities)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

