/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.StackTraceError;

@JsonPropertyOrder(value={"name", "records", "updated_records", "warnings", "errors", "filtered", "failures"})
public class StepSummary {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_RECORDS = "records";
    @Nullable
    private Integer records;
    public static final String JSON_PROPERTY_UPDATED_RECORDS = "updated_records";
    @Nullable
    private Integer updatedRecords;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    @Nullable
    private Integer warnings;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    @Nullable
    private Integer errors;
    public static final String JSON_PROPERTY_FILTERED = "filtered";
    @Nullable
    private Integer filtered;
    public static final String JSON_PROPERTY_FAILURES = "failures";
    @Nullable
    private List<StackTraceError> failures = new ArrayList<StackTraceError>();

    public StepSummary name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public StepSummary records(@Nullable Integer records) {
        this.records = records;
        return this;
    }

    @Nullable
    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRecords() {
        return this.records;
    }

    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecords(@Nullable Integer records) {
        this.records = records;
    }

    public StepSummary updatedRecords(@Nullable Integer updatedRecords) {
        this.updatedRecords = updatedRecords;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUpdatedRecords() {
        return this.updatedRecords;
    }

    @JsonProperty(value="updated_records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedRecords(@Nullable Integer updatedRecords) {
        this.updatedRecords = updatedRecords;
    }

    public StepSummary warnings(@Nullable Integer warnings) {
        this.warnings = warnings;
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(@Nullable Integer warnings) {
        this.warnings = warnings;
    }

    public StepSummary errors(@Nullable Integer errors) {
        this.errors = errors;
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(@Nullable Integer errors) {
        this.errors = errors;
    }

    public StepSummary filtered(@Nullable Integer filtered) {
        this.filtered = filtered;
        return this;
    }

    @Nullable
    @JsonProperty(value="filtered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFiltered() {
        return this.filtered;
    }

    @JsonProperty(value="filtered")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiltered(@Nullable Integer filtered) {
        this.filtered = filtered;
    }

    public StepSummary failures(@Nullable List<StackTraceError> failures) {
        this.failures = failures;
        return this;
    }

    public StepSummary addFailuresItem(StackTraceError failuresItem) {
        if (this.failures == null) {
            this.failures = new ArrayList<StackTraceError>();
        }
        this.failures.add(failuresItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="failures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StackTraceError> getFailures() {
        return this.failures;
    }

    @JsonProperty(value="failures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailures(@Nullable List<StackTraceError> failures) {
        this.failures = failures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepSummary stepSummary = (StepSummary)o;
        return Objects.equals(this.name, stepSummary.name) && Objects.equals(this.records, stepSummary.records) && Objects.equals(this.updatedRecords, stepSummary.updatedRecords) && Objects.equals(this.warnings, stepSummary.warnings) && Objects.equals(this.errors, stepSummary.errors) && Objects.equals(this.filtered, stepSummary.filtered) && Objects.equals(this.failures, stepSummary.failures);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.records, this.updatedRecords, this.warnings, this.errors, this.filtered, this.failures);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StepSummary {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    records: ").append(this.toIndentedString(this.records)).append("\n");
        sb.append("    updatedRecords: ").append(this.toIndentedString(this.updatedRecords)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    filtered: ").append(this.toIndentedString(this.filtered)).append("\n");
        sb.append("    failures: ").append(this.toIndentedString(this.failures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

