/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AssetCertification;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.CustomMetric;
import org.openmetadata.client.model.DataModel;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TableConstraint;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TableJoins;
import org.openmetadata.client.model.TablePartition;
import org.openmetadata.client.model.TableProfile;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"id", "name", "displayName", "fullyQualifiedName", "description", "version", "updatedAt", "updatedBy", "href", "tableType", "columns", "tableConstraints", "tablePartition", "owners", "databaseSchema", "database", "service", "serviceType", "location", "locationPath", "schemaDefinition", "tags", "usageSummary", "followers", "joins", "sampleData", "tableProfilerConfig", "customMetrics", "profile", "testSuite", "dataModel", "changeDescription", "incrementalChangeDescription", "deleted", "retentionPeriod", "extension", "sourceUrl", "domains", "dataProducts", "fileFormat", "votes", "lifeCycle", "certification", "sourceHash", "processedLineage", "queries", "reviewers", "experts", "style", "provider", "children"})
public class Table {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    @Nullable
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Double version;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    @Nullable
    private String updatedBy;
    public static final String JSON_PROPERTY_HREF = "href";
    @Nullable
    private URI href;
    public static final String JSON_PROPERTY_TABLE_TYPE = "tableType";
    @Nullable
    private TableTypeEnum tableType;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nonnull
    private List<Column> columns = new ArrayList<Column>();
    public static final String JSON_PROPERTY_TABLE_CONSTRAINTS = "tableConstraints";
    @Nullable
    private List<TableConstraint> tableConstraints = new ArrayList<TableConstraint>();
    public static final String JSON_PROPERTY_TABLE_PARTITION = "tablePartition";
    @Nullable
    private TablePartition tablePartition;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    @Nullable
    private List<EntityReference> owners = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DATABASE_SCHEMA = "databaseSchema";
    @Nullable
    private EntityReference databaseSchema;
    public static final String JSON_PROPERTY_DATABASE = "database";
    @Nullable
    private EntityReference database;
    public static final String JSON_PROPERTY_SERVICE = "service";
    @Nullable
    private EntityReference service;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    @Nullable
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nullable
    private EntityReference location;
    public static final String JSON_PROPERTY_LOCATION_PATH = "locationPath";
    @Nullable
    private String locationPath;
    public static final String JSON_PROPERTY_SCHEMA_DEFINITION = "schemaDefinition";
    @Nullable
    private String schemaDefinition;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<TagLabel> tags = new ArrayList<TagLabel>();
    public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
    @Nullable
    private UsageDetails usageSummary;
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    @Nullable
    private List<EntityReference> followers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_JOINS = "joins";
    @Nullable
    private TableJoins joins;
    public static final String JSON_PROPERTY_SAMPLE_DATA = "sampleData";
    @Nullable
    private TableData sampleData;
    public static final String JSON_PROPERTY_TABLE_PROFILER_CONFIG = "tableProfilerConfig";
    @Nullable
    private TableProfilerConfig tableProfilerConfig;
    public static final String JSON_PROPERTY_CUSTOM_METRICS = "customMetrics";
    @Nullable
    private List<CustomMetric> customMetrics = new ArrayList<CustomMetric>();
    public static final String JSON_PROPERTY_PROFILE = "profile";
    @Nullable
    private TableProfile profile;
    public static final String JSON_PROPERTY_TEST_SUITE = "testSuite";
    @Nullable
    private EntityReference testSuite;
    public static final String JSON_PROPERTY_DATA_MODEL = "dataModel";
    @Nullable
    private DataModel dataModel;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    @Nullable
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_INCREMENTAL_CHANGE_DESCRIPTION = "incrementalChangeDescription";
    @Nullable
    private ChangeDescription incrementalChangeDescription;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    @Nullable
    private Boolean deleted;
    public static final String JSON_PROPERTY_RETENTION_PERIOD = "retentionPeriod";
    @Nullable
    private String retentionPeriod;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    @Nullable
    private Object extension;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    @Nullable
    private String sourceUrl;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    @Nullable
    private List<EntityReference> domains = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    @Nullable
    private List<EntityReference> dataProducts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
    @Nullable
    private FileFormatEnum fileFormat;
    public static final String JSON_PROPERTY_VOTES = "votes";
    @Nullable
    private Votes votes;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    @Nullable
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_CERTIFICATION = "certification";
    @Nullable
    private AssetCertification certification;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    @Nullable
    private String sourceHash;
    public static final String JSON_PROPERTY_PROCESSED_LINEAGE = "processedLineage";
    @Nullable
    private Boolean processedLineage;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    @Nullable
    private List<String> queries = new ArrayList<String>();
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    @Nullable
    private List<EntityReference> reviewers = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    @Nullable
    private List<EntityReference> experts = new ArrayList<EntityReference>();
    public static final String JSON_PROPERTY_STYLE = "style";
    @Nullable
    private Style style;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nullable
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private List<EntityReference> children = new ArrayList<EntityReference>();

    public Table id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public Table name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Table displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public Table fullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(@Nullable String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Table description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Table version(@Nullable Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Double version) {
        this.version = version;
    }

    public Table updatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Table updatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(@Nullable String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Table href(@Nullable URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(@Nullable URI href) {
        this.href = href;
    }

    public Table tableType(@Nullable TableTypeEnum tableType) {
        this.tableType = tableType;
        return this;
    }

    @Nullable
    @JsonProperty(value="tableType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableTypeEnum getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="tableType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTableType(@Nullable TableTypeEnum tableType) {
        this.tableType = tableType;
    }

    public Table columns(@Nonnull List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public Table addColumnsItem(Column columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setColumns(@Nonnull List<Column> columns) {
        this.columns = columns;
    }

    public Table tableConstraints(@Nullable List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
        return this;
    }

    public Table addTableConstraintsItem(TableConstraint tableConstraintsItem) {
        if (this.tableConstraints == null) {
            this.tableConstraints = new ArrayList<TableConstraint>();
        }
        this.tableConstraints.add(tableConstraintsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tableConstraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    @JsonProperty(value="tableConstraints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTableConstraints(@Nullable List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
    }

    public Table tablePartition(@Nullable TablePartition tablePartition) {
        this.tablePartition = tablePartition;
        return this;
    }

    @Nullable
    @JsonProperty(value="tablePartition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TablePartition getTablePartition() {
        return this.tablePartition;
    }

    @JsonProperty(value="tablePartition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTablePartition(@Nullable TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    public Table owners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public Table addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(@Nullable List<EntityReference> owners) {
        this.owners = owners;
    }

    public Table databaseSchema(@Nullable EntityReference databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @Nullable
    @JsonProperty(value="databaseSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatabaseSchema(@Nullable EntityReference databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public Table database(@Nullable EntityReference database) {
        this.database = database;
        return this;
    }

    @Nullable
    @JsonProperty(value="database")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatabase(@Nullable EntityReference database) {
        this.database = database;
    }

    public Table service(@Nullable EntityReference service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(@Nullable EntityReference service) {
        this.service = service;
    }

    public Table serviceType(@Nullable ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceType(@Nullable ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public Table location(@Nullable EntityReference location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(@Nullable EntityReference location) {
        this.location = location;
    }

    public Table locationPath(@Nullable String locationPath) {
        this.locationPath = locationPath;
        return this;
    }

    @Nullable
    @JsonProperty(value="locationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationPath() {
        return this.locationPath;
    }

    @JsonProperty(value="locationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationPath(@Nullable String locationPath) {
        this.locationPath = locationPath;
    }

    public Table schemaDefinition(@Nullable String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
        return this;
    }

    @Nullable
    @JsonProperty(value="schemaDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @JsonProperty(value="schemaDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaDefinition(@Nullable String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    public Table tags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public Table addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<TagLabel> tags) {
        this.tags = tags;
    }

    public Table usageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Nullable
    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsageSummary(@Nullable UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public Table followers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public Table addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(@Nullable List<EntityReference> followers) {
        this.followers = followers;
    }

    public Table joins(@Nullable TableJoins joins) {
        this.joins = joins;
        return this;
    }

    @Nullable
    @JsonProperty(value="joins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableJoins getJoins() {
        return this.joins;
    }

    @JsonProperty(value="joins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJoins(@Nullable TableJoins joins) {
        this.joins = joins;
    }

    public Table sampleData(@Nullable TableData sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @Nullable
    @JsonProperty(value="sampleData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableData getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSampleData(@Nullable TableData sampleData) {
        this.sampleData = sampleData;
    }

    public Table tableProfilerConfig(@Nullable TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
        return this;
    }

    @Nullable
    @JsonProperty(value="tableProfilerConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableProfilerConfig getTableProfilerConfig() {
        return this.tableProfilerConfig;
    }

    @JsonProperty(value="tableProfilerConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTableProfilerConfig(@Nullable TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
    }

    public Table customMetrics(@Nullable List<CustomMetric> customMetrics) {
        this.customMetrics = customMetrics;
        return this;
    }

    public Table addCustomMetricsItem(CustomMetric customMetricsItem) {
        if (this.customMetrics == null) {
            this.customMetrics = new ArrayList<CustomMetric>();
        }
        this.customMetrics.add(customMetricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="customMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CustomMetric> getCustomMetrics() {
        return this.customMetrics;
    }

    @JsonProperty(value="customMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomMetrics(@Nullable List<CustomMetric> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public Table profile(@Nullable TableProfile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(@Nullable TableProfile profile) {
        this.profile = profile;
    }

    public Table testSuite(@Nullable EntityReference testSuite) {
        this.testSuite = testSuite;
        return this;
    }

    @Nullable
    @JsonProperty(value="testSuite")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getTestSuite() {
        return this.testSuite;
    }

    @JsonProperty(value="testSuite")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestSuite(@Nullable EntityReference testSuite) {
        this.testSuite = testSuite;
    }

    public Table dataModel(@Nullable DataModel dataModel) {
        this.dataModel = dataModel;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataModel getDataModel() {
        return this.dataModel;
    }

    @JsonProperty(value="dataModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataModel(@Nullable DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public Table changeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(@Nullable ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Table incrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getIncrementalChangeDescription() {
        return this.incrementalChangeDescription;
    }

    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalChangeDescription(@Nullable ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
    }

    public Table deleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
    }

    public Table retentionPeriod(@Nullable String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    @Nullable
    @JsonProperty(value="retentionPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @JsonProperty(value="retentionPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRetentionPeriod(@Nullable String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public Table extension(@Nullable Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(@Nullable Object extension) {
        this.extension = extension;
    }

    public Table sourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(@Nullable String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Table domains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
        return this;
    }

    public Table addDomainsItem(EntityReference domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<EntityReference>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(@Nullable List<EntityReference> domains) {
        this.domains = domains;
    }

    public Table dataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public Table addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(@Nullable List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public Table fileFormat(@Nullable FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Nullable
    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FileFormatEnum getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileFormat(@Nullable FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Table votes(@Nullable Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(@Nullable Votes votes) {
        this.votes = votes;
    }

    public Table lifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(@Nullable LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public Table certification(@Nullable AssetCertification certification) {
        this.certification = certification;
        return this;
    }

    @Nullable
    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetCertification getCertification() {
        return this.certification;
    }

    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertification(@Nullable AssetCertification certification) {
        this.certification = certification;
    }

    public Table sourceHash(@Nullable String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(@Nullable String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public Table processedLineage(@Nullable Boolean processedLineage) {
        this.processedLineage = processedLineage;
        return this;
    }

    @Nullable
    @JsonProperty(value="processedLineage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProcessedLineage() {
        return this.processedLineage;
    }

    @JsonProperty(value="processedLineage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessedLineage(@Nullable Boolean processedLineage) {
        this.processedLineage = processedLineage;
    }

    public Table queries(@Nullable List<String> queries) {
        this.queries = queries;
        return this;
    }

    public Table addQueriesItem(String queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<String>();
        }
        this.queries.add(queriesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getQueries() {
        return this.queries;
    }

    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQueries(@Nullable List<String> queries) {
        this.queries = queries;
    }

    public Table reviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public Table addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(@Nullable List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public Table experts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public Table addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(@Nullable List<EntityReference> experts) {
        this.experts = experts;
    }

    public Table style(@Nullable Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(@Nullable Style style) {
        this.style = style;
    }

    public Table provider(@Nullable ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(@Nullable ProviderEnum provider) {
        this.provider = provider;
    }

    public Table children(@Nullable List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public Table addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable List<EntityReference> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.id, table.id) && Objects.equals(this.name, table.name) && Objects.equals(this.displayName, table.displayName) && Objects.equals(this.fullyQualifiedName, table.fullyQualifiedName) && Objects.equals(this.description, table.description) && Objects.equals(this.version, table.version) && Objects.equals(this.updatedAt, table.updatedAt) && Objects.equals(this.updatedBy, table.updatedBy) && Objects.equals(this.href, table.href) && Objects.equals((Object)this.tableType, (Object)table.tableType) && Objects.equals(this.columns, table.columns) && Objects.equals(this.tableConstraints, table.tableConstraints) && Objects.equals(this.tablePartition, table.tablePartition) && Objects.equals(this.owners, table.owners) && Objects.equals(this.databaseSchema, table.databaseSchema) && Objects.equals(this.database, table.database) && Objects.equals(this.service, table.service) && Objects.equals((Object)this.serviceType, (Object)table.serviceType) && Objects.equals(this.location, table.location) && Objects.equals(this.locationPath, table.locationPath) && Objects.equals(this.schemaDefinition, table.schemaDefinition) && Objects.equals(this.tags, table.tags) && Objects.equals(this.usageSummary, table.usageSummary) && Objects.equals(this.followers, table.followers) && Objects.equals(this.joins, table.joins) && Objects.equals(this.sampleData, table.sampleData) && Objects.equals(this.tableProfilerConfig, table.tableProfilerConfig) && Objects.equals(this.customMetrics, table.customMetrics) && Objects.equals(this.profile, table.profile) && Objects.equals(this.testSuite, table.testSuite) && Objects.equals(this.dataModel, table.dataModel) && Objects.equals(this.changeDescription, table.changeDescription) && Objects.equals(this.incrementalChangeDescription, table.incrementalChangeDescription) && Objects.equals(this.deleted, table.deleted) && Objects.equals(this.retentionPeriod, table.retentionPeriod) && Objects.equals(this.extension, table.extension) && Objects.equals(this.sourceUrl, table.sourceUrl) && Objects.equals(this.domains, table.domains) && Objects.equals(this.dataProducts, table.dataProducts) && Objects.equals((Object)this.fileFormat, (Object)table.fileFormat) && Objects.equals(this.votes, table.votes) && Objects.equals(this.lifeCycle, table.lifeCycle) && Objects.equals(this.certification, table.certification) && Objects.equals(this.sourceHash, table.sourceHash) && Objects.equals(this.processedLineage, table.processedLineage) && Objects.equals(this.queries, table.queries) && Objects.equals(this.reviewers, table.reviewers) && Objects.equals(this.experts, table.experts) && Objects.equals(this.style, table.style) && Objects.equals((Object)this.provider, (Object)table.provider) && Objects.equals(this.children, table.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.displayName, this.fullyQualifiedName, this.description, this.version, this.updatedAt, this.updatedBy, this.href, this.tableType, this.columns, this.tableConstraints, this.tablePartition, this.owners, this.databaseSchema, this.database, this.service, this.serviceType, this.location, this.locationPath, this.schemaDefinition, this.tags, this.usageSummary, this.followers, this.joins, this.sampleData, this.tableProfilerConfig, this.customMetrics, this.profile, this.testSuite, this.dataModel, this.changeDescription, this.incrementalChangeDescription, this.deleted, this.retentionPeriod, this.extension, this.sourceUrl, this.domains, this.dataProducts, this.fileFormat, this.votes, this.lifeCycle, this.certification, this.sourceHash, this.processedLineage, this.queries, this.reviewers, this.experts, this.style, this.provider, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Table {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    tableType: ").append(this.toIndentedString((Object)this.tableType)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    tableConstraints: ").append(this.toIndentedString(this.tableConstraints)).append("\n");
        sb.append("    tablePartition: ").append(this.toIndentedString(this.tablePartition)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    databaseSchema: ").append(this.toIndentedString(this.databaseSchema)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    locationPath: ").append(this.toIndentedString(this.locationPath)).append("\n");
        sb.append("    schemaDefinition: ").append(this.toIndentedString(this.schemaDefinition)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    joins: ").append(this.toIndentedString(this.joins)).append("\n");
        sb.append("    sampleData: ").append(this.toIndentedString(this.sampleData)).append("\n");
        sb.append("    tableProfilerConfig: ").append(this.toIndentedString(this.tableProfilerConfig)).append("\n");
        sb.append("    customMetrics: ").append(this.toIndentedString(this.customMetrics)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    testSuite: ").append(this.toIndentedString(this.testSuite)).append("\n");
        sb.append("    dataModel: ").append(this.toIndentedString(this.dataModel)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    incrementalChangeDescription: ").append(this.toIndentedString(this.incrementalChangeDescription)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    retentionPeriod: ").append(this.toIndentedString(this.retentionPeriod)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString((Object)this.fileFormat)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    certification: ").append(this.toIndentedString(this.certification)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    processedLineage: ").append(this.toIndentedString(this.processedLineage)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TableTypeEnum {
        REGULAR(String.valueOf("Regular")),
        EXTERNAL(String.valueOf("External")),
        DYNAMIC(String.valueOf("Dynamic")),
        VIEW(String.valueOf("View")),
        SECURE_VIEW(String.valueOf("SecureView")),
        MATERIALIZED_VIEW(String.valueOf("MaterializedView")),
        ICEBERG(String.valueOf("Iceberg")),
        LOCAL(String.valueOf("Local")),
        PARTITIONED(String.valueOf("Partitioned")),
        FOREIGN(String.valueOf("Foreign")),
        TRANSIENT(String.valueOf("Transient")),
        STREAM(String.valueOf("Stream"));

        private String value;

        private TableTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TableTypeEnum fromValue(String value) {
            for (TableTypeEnum b : TableTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ServiceTypeEnum {
        BIG_QUERY(String.valueOf("BigQuery")),
        BIG_TABLE(String.valueOf("BigTable")),
        MYSQL(String.valueOf("Mysql")),
        REDSHIFT(String.valueOf("Redshift")),
        SNOWFLAKE(String.valueOf("Snowflake")),
        POSTGRES(String.valueOf("Postgres")),
        MSSQL(String.valueOf("Mssql")),
        ORACLE(String.valueOf("Oracle")),
        ATHENA(String.valueOf("Athena")),
        HIVE(String.valueOf("Hive")),
        IMPALA(String.valueOf("Impala")),
        PRESTO(String.valueOf("Presto")),
        TRINO(String.valueOf("Trino")),
        VERTICA(String.valueOf("Vertica")),
        GLUE(String.valueOf("Glue")),
        MARIA_DB(String.valueOf("MariaDB")),
        DRUID(String.valueOf("Druid")),
        DB2(String.valueOf("Db2")),
        CLICKHOUSE(String.valueOf("Clickhouse")),
        DATABRICKS(String.valueOf("Databricks")),
        AZURE_SQL(String.valueOf("AzureSQL")),
        DYNAMO_DB(String.valueOf("DynamoDB")),
        SINGLE_STORE(String.valueOf("SingleStore")),
        SQ_LITE(String.valueOf("SQLite")),
        DELTA_LAKE(String.valueOf("DeltaLake")),
        SALESFORCE(String.valueOf("Salesforce")),
        PINOT_DB(String.valueOf("PinotDB")),
        DATALAKE(String.valueOf("Datalake")),
        DOMO_DATABASE(String.valueOf("DomoDatabase")),
        QUERY_LOG(String.valueOf("QueryLog")),
        CUSTOM_DATABASE(String.valueOf("CustomDatabase")),
        DBT(String.valueOf("Dbt")),
        SAP_HANA(String.valueOf("SapHana")),
        MONGO_DB(String.valueOf("MongoDB")),
        CASSANDRA(String.valueOf("Cassandra")),
        COUCHBASE(String.valueOf("Couchbase")),
        GREENPLUM(String.valueOf("Greenplum")),
        DORIS(String.valueOf("Doris")),
        UNITY_CATALOG(String.valueOf("UnityCatalog")),
        SAS(String.valueOf("SAS")),
        ICEBERG(String.valueOf("Iceberg")),
        TERADATA(String.valueOf("Teradata")),
        SAP_ERP(String.valueOf("SapErp")),
        SYNAPSE(String.valueOf("Synapse")),
        EXASOL(String.valueOf("Exasol")),
        COCKROACH(String.valueOf("Cockroach")),
        SSAS(String.valueOf("SSAS")),
        EPIC(String.valueOf("Epic"));

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FileFormatEnum {
        CSV(String.valueOf("csv")),
        CSV_GZ(String.valueOf("csv.gz")),
        TSV(String.valueOf("tsv")),
        AVRO(String.valueOf("avro")),
        PARQUET(String.valueOf("parquet")),
        PQ(String.valueOf("pq")),
        PQT(String.valueOf("pqt")),
        PARQ(String.valueOf("parq")),
        PARQUET_SNAPPY(String.valueOf("parquet.snappy")),
        JSON(String.valueOf("json")),
        JSON_GZ(String.valueOf("json.gz")),
        JSON_ZIP(String.valueOf("json.zip")),
        JSONL(String.valueOf("jsonl")),
        JSONL_GZ(String.valueOf("jsonl.gz")),
        JSONL_ZIP(String.valueOf("jsonl.zip"));

        private String value;

        private FileFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileFormatEnum fromValue(String value) {
            for (FileFormatEnum b : FileFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProviderEnum {
        SYSTEM(String.valueOf("system")),
        USER(String.valueOf("user")),
        AUTOMATION(String.valueOf("automation"));

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

