/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"constraintType", "columns", "referredColumns", "relationshipType"})
public class TableConstraint {
    public static final String JSON_PROPERTY_CONSTRAINT_TYPE = "constraintType";
    @Nullable
    private ConstraintTypeEnum constraintType;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<String> columns = new ArrayList<String>();
    public static final String JSON_PROPERTY_REFERRED_COLUMNS = "referredColumns";
    @Nullable
    private List<String> referredColumns = new ArrayList<String>();
    public static final String JSON_PROPERTY_RELATIONSHIP_TYPE = "relationshipType";
    @Nullable
    private RelationshipTypeEnum relationshipType;

    public TableConstraint constraintType(@Nullable ConstraintTypeEnum constraintType) {
        this.constraintType = constraintType;
        return this;
    }

    @Nullable
    @JsonProperty(value="constraintType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConstraintTypeEnum getConstraintType() {
        return this.constraintType;
    }

    @JsonProperty(value="constraintType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConstraintType(@Nullable ConstraintTypeEnum constraintType) {
        this.constraintType = constraintType;
    }

    public TableConstraint columns(@Nullable List<String> columns) {
        this.columns = columns;
        return this;
    }

    public TableConstraint addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<String> columns) {
        this.columns = columns;
    }

    public TableConstraint referredColumns(@Nullable List<String> referredColumns) {
        this.referredColumns = referredColumns;
        return this;
    }

    public TableConstraint addReferredColumnsItem(String referredColumnsItem) {
        if (this.referredColumns == null) {
            this.referredColumns = new ArrayList<String>();
        }
        this.referredColumns.add(referredColumnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="referredColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getReferredColumns() {
        return this.referredColumns;
    }

    @JsonProperty(value="referredColumns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferredColumns(@Nullable List<String> referredColumns) {
        this.referredColumns = referredColumns;
    }

    public TableConstraint relationshipType(@Nullable RelationshipTypeEnum relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationshipType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipTypeEnum getRelationshipType() {
        return this.relationshipType;
    }

    @JsonProperty(value="relationshipType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationshipType(@Nullable RelationshipTypeEnum relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableConstraint tableConstraint = (TableConstraint)o;
        return Objects.equals((Object)this.constraintType, (Object)tableConstraint.constraintType) && Objects.equals(this.columns, tableConstraint.columns) && Objects.equals(this.referredColumns, tableConstraint.referredColumns) && Objects.equals((Object)this.relationshipType, (Object)tableConstraint.relationshipType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constraintType, this.columns, this.referredColumns, this.relationshipType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableConstraint {\n");
        sb.append("    constraintType: ").append(this.toIndentedString((Object)this.constraintType)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    referredColumns: ").append(this.toIndentedString(this.referredColumns)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString((Object)this.relationshipType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConstraintTypeEnum {
        UNIQUE(String.valueOf("UNIQUE")),
        PRIMARY_KEY(String.valueOf("PRIMARY_KEY")),
        FOREIGN_KEY(String.valueOf("FOREIGN_KEY")),
        SORT_KEY(String.valueOf("SORT_KEY")),
        DIST_KEY(String.valueOf("DIST_KEY")),
        CLUSTER_KEY(String.valueOf("CLUSTER_KEY"));

        private String value;

        private ConstraintTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConstraintTypeEnum fromValue(String value) {
            for (ConstraintTypeEnum b : ConstraintTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RelationshipTypeEnum {
        ONE_TO_ONE(String.valueOf("ONE_TO_ONE")),
        ONE_TO_MANY(String.valueOf("ONE_TO_MANY")),
        MANY_TO_ONE(String.valueOf("MANY_TO_ONE")),
        MANY_TO_MANY(String.valueOf("MANY_TO_MANY"));

        private String value;

        private RelationshipTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RelationshipTypeEnum fromValue(String value) {
            for (RelationshipTypeEnum b : RelationshipTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

