/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.Metric;

@JsonPropertyOrder(value={"id", "stateId", "timestamp", "testCaseResolutionStatusType", "testCaseResolutionStatusDetails", "updatedBy", "updatedAt", "testCaseReference", "severity", "metrics"})
public class TestCaseResolutionStatus {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private UUID id;
    public static final String JSON_PROPERTY_STATE_ID = "stateId";
    @Nullable
    private UUID stateId;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    @Nullable
    private Long timestamp;
    public static final String JSON_PROPERTY_TEST_CASE_RESOLUTION_STATUS_TYPE = "testCaseResolutionStatusType";
    @Nonnull
    private TestCaseResolutionStatusTypeEnum testCaseResolutionStatusType;
    public static final String JSON_PROPERTY_TEST_CASE_RESOLUTION_STATUS_DETAILS = "testCaseResolutionStatusDetails";
    @Nullable
    private Object testCaseResolutionStatusDetails;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    @Nullable
    private EntityReference updatedBy;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    @Nullable
    private Long updatedAt;
    public static final String JSON_PROPERTY_TEST_CASE_REFERENCE = "testCaseReference";
    @Nullable
    private EntityReference testCaseReference;
    public static final String JSON_PROPERTY_SEVERITY = "severity";
    @Nullable
    private SeverityEnum severity;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    @Nullable
    private List<Metric> metrics = new ArrayList<Metric>();

    public TestCaseResolutionStatus id(@Nullable UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable UUID id) {
        this.id = id;
    }

    public TestCaseResolutionStatus stateId(@Nullable UUID stateId) {
        this.stateId = stateId;
        return this;
    }

    @Nullable
    @JsonProperty(value="stateId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getStateId() {
        return this.stateId;
    }

    @JsonProperty(value="stateId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateId(@Nullable UUID stateId) {
        this.stateId = stateId;
    }

    public TestCaseResolutionStatus timestamp(@Nullable Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(@Nullable Long timestamp) {
        this.timestamp = timestamp;
    }

    public TestCaseResolutionStatus testCaseResolutionStatusType(@Nonnull TestCaseResolutionStatusTypeEnum testCaseResolutionStatusType) {
        this.testCaseResolutionStatusType = testCaseResolutionStatusType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="testCaseResolutionStatusType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TestCaseResolutionStatusTypeEnum getTestCaseResolutionStatusType() {
        return this.testCaseResolutionStatusType;
    }

    @JsonProperty(value="testCaseResolutionStatusType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestCaseResolutionStatusType(@Nonnull TestCaseResolutionStatusTypeEnum testCaseResolutionStatusType) {
        this.testCaseResolutionStatusType = testCaseResolutionStatusType;
    }

    public TestCaseResolutionStatus testCaseResolutionStatusDetails(@Nullable Object testCaseResolutionStatusDetails) {
        this.testCaseResolutionStatusDetails = testCaseResolutionStatusDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseResolutionStatusDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTestCaseResolutionStatusDetails() {
        return this.testCaseResolutionStatusDetails;
    }

    @JsonProperty(value="testCaseResolutionStatusDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseResolutionStatusDetails(@Nullable Object testCaseResolutionStatusDetails) {
        this.testCaseResolutionStatusDetails = testCaseResolutionStatusDetails;
    }

    public TestCaseResolutionStatus updatedBy(@Nullable EntityReference updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(@Nullable EntityReference updatedBy) {
        this.updatedBy = updatedBy;
    }

    public TestCaseResolutionStatus updatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(@Nullable Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TestCaseResolutionStatus testCaseReference(@Nullable EntityReference testCaseReference) {
        this.testCaseReference = testCaseReference;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getTestCaseReference() {
        return this.testCaseReference;
    }

    @JsonProperty(value="testCaseReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseReference(@Nullable EntityReference testCaseReference) {
        this.testCaseReference = testCaseReference;
    }

    public TestCaseResolutionStatus severity(@Nullable SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @JsonProperty(value="severity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSeverity(@Nullable SeverityEnum severity) {
        this.severity = severity;
    }

    public TestCaseResolutionStatus metrics(@Nullable List<Metric> metrics) {
        this.metrics = metrics;
        return this;
    }

    public TestCaseResolutionStatus addMetricsItem(Metric metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(@Nullable List<Metric> metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseResolutionStatus testCaseResolutionStatus = (TestCaseResolutionStatus)o;
        return Objects.equals(this.id, testCaseResolutionStatus.id) && Objects.equals(this.stateId, testCaseResolutionStatus.stateId) && Objects.equals(this.timestamp, testCaseResolutionStatus.timestamp) && Objects.equals((Object)this.testCaseResolutionStatusType, (Object)testCaseResolutionStatus.testCaseResolutionStatusType) && Objects.equals(this.testCaseResolutionStatusDetails, testCaseResolutionStatus.testCaseResolutionStatusDetails) && Objects.equals(this.updatedBy, testCaseResolutionStatus.updatedBy) && Objects.equals(this.updatedAt, testCaseResolutionStatus.updatedAt) && Objects.equals(this.testCaseReference, testCaseResolutionStatus.testCaseReference) && Objects.equals((Object)this.severity, (Object)testCaseResolutionStatus.severity) && Objects.equals(this.metrics, testCaseResolutionStatus.metrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.stateId, this.timestamp, this.testCaseResolutionStatusType, this.testCaseResolutionStatusDetails, this.updatedBy, this.updatedAt, this.testCaseReference, this.severity, this.metrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestCaseResolutionStatus {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    stateId: ").append(this.toIndentedString(this.stateId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    testCaseResolutionStatusType: ").append(this.toIndentedString((Object)this.testCaseResolutionStatusType)).append("\n");
        sb.append("    testCaseResolutionStatusDetails: ").append(this.toIndentedString(this.testCaseResolutionStatusDetails)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    testCaseReference: ").append(this.toIndentedString(this.testCaseReference)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TestCaseResolutionStatusTypeEnum {
        NEW(String.valueOf("New")),
        ACK(String.valueOf("Ack")),
        ASSIGNED(String.valueOf("Assigned")),
        RESOLVED(String.valueOf("Resolved"));

        private String value;

        private TestCaseResolutionStatusTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TestCaseResolutionStatusTypeEnum fromValue(String value) {
            for (TestCaseResolutionStatusTypeEnum b : TestCaseResolutionStatusTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SeverityEnum {
        SEVERITY1(String.valueOf("Severity1")),
        SEVERITY2(String.valueOf("Severity2")),
        SEVERITY3(String.valueOf("Severity3")),
        SEVERITY4(String.valueOf("Severity4")),
        SEVERITY5(String.valueOf("Severity5"));

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SeverityEnum fromValue(String value) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

