/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.exception.EncodeException;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.SerializationFlag;

public abstract class AbsOpenApiSchema<M extends OpenApiSchema<M>>
implements OpenApiSchema<M> {
    @Override
    public JsonNode toNode(OAIContext context, boolean followRefs) throws EncodeException {
        AbsOpenApiSchema model = followRefs ? this.copy(context, true) : this;
        return TreeUtil.toJsonNode((Object)model);
    }

    @Override
    public String toString(OAIContext context, EnumSet<SerializationFlag> flags) throws EncodeException {
        AbsOpenApiSchema model;
        AbsOpenApiSchema<M> absOpenApiSchema = model = flags.contains((Object)SerializationFlag.FOLLOW_REFS) ? this.copy(context, true) : this;
        if (flags.contains((Object)SerializationFlag.OUT_AS_YAML)) {
            return TreeUtil.toYaml((Object)model);
        }
        return TreeUtil.toJson((Object)model);
    }

    protected <T> List<T> copyList(List<T> original) {
        if (original != null) {
            return new ArrayList<T>(original);
        }
        return null;
    }

    protected <K, T> Map<K, T> copyMap(Map<K, T> original) {
        if (original != null) {
            return new HashMap<K, T>(original);
        }
        return null;
    }

    protected <T extends OpenApiSchema<T>> T copyField(T original, OAIContext context, boolean followRefs) {
        if (original != null) {
            return original.copy(context, followRefs);
        }
        return null;
    }

    protected <T extends OpenApiSchema<T>> List<T> copyList(List<T> original, OAIContext context, boolean followRefs) {
        if (original != null) {
            ArrayList copy = new ArrayList(original.size());
            for (OpenApiSchema element : original) {
                copy.add(element.copy(context, followRefs));
            }
            return copy;
        }
        return null;
    }

    protected <K, T extends OpenApiSchema<T>> Map<K, T> copyMap(Map<K, T> original, OAIContext context, boolean followRefs) {
        if (original != null) {
            HashMap copy = new HashMap(original.size());
            for (Map.Entry<K, T> element : original.entrySet()) {
                OpenApiSchema schema = (OpenApiSchema)element.getValue();
                if (schema != null) {
                    copy.put(element.getKey(), schema.copy(context, followRefs));
                    continue;
                }
                copy.put(element.getKey(), null);
            }
            return copy;
        }
        return null;
    }

    protected <K, V> boolean mapHas(Map<K, V> map, K key) {
        return map != null && map.containsKey(key);
    }

    protected <K, V> V mapGet(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    protected <K, V> void mapRemove(Map<K, V> map, K key) {
        if (map != null) {
            map.remove(key);
        }
    }

    protected <K> List<K> listAdd(List<K> list, K value) {
        if (list == null) {
            list = new ArrayList<K>();
        }
        list.add(value);
        return list;
    }

    protected <K> List<K> listAdd(List<K> list, int index, K value) {
        if (list == null) {
            list = new ArrayList<K>();
        }
        list.add(index, value);
        return list;
    }

    protected <K> boolean listRemove(List<K> list, K value) {
        if (list == null) {
            return false;
        }
        return list.remove(value);
    }
}

