/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.AbsOpenApiSchema;
import org.openapi4j.parser.model.OpenApiSchema;

public abstract class AbsRefOpenApiSchema<M extends OpenApiSchema<M>>
extends AbsOpenApiSchema<M> {
    @JsonProperty(value="$ref")
    private String ref;

    public String getRef() {
        return this.ref;
    }

    public boolean isRef() {
        return this.ref != null;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public M copy(OAIContext context, boolean followRefs) {
        if (this.isRef()) {
            if (followRefs) {
                Reference reference = context.getReferenceRegistry().getRef(this.getRef());
                if (reference != null) {
                    OpenApiSchema copy = (OpenApiSchema)TreeUtil.json.convertValue((Object)reference.getContent(), this.getClass());
                    return copy.copy(context, true);
                }
            } else {
                return this.copyReference(context);
            }
        }
        return this.copyContent(context, followRefs);
    }

    protected abstract M copyReference(OAIContext var1);

    protected abstract M copyContent(OAIContext var1, boolean var2);
}

