/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.model.OAI;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;
import org.openapi4j.parser.model.v3.Components;
import org.openapi4j.parser.model.v3.ExternalDocs;
import org.openapi4j.parser.model.v3.Info;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.model.v3.SecurityRequirement;
import org.openapi4j.parser.model.v3.Server;
import org.openapi4j.parser.model.v3.Tag;

public class OpenApi3
extends AbsExtendedOpenApiSchema<OpenApi3>
implements OAI {
    private String openapi;
    private Info info;
    private List<Server> servers;
    private List<Tag> tags;
    @JsonInclude
    private Map<String, Path> paths;
    private Components components;
    private ExternalDocs externalDocs;
    private SecurityRequirement security;
    @JsonIgnore
    private OAIContext context;

    public String getOpenapi() {
        return this.openapi;
    }

    public OpenApi3 setOpenapi(String openapi) {
        this.openapi = openapi;
        return this;
    }

    public Info getInfo() {
        return this.info;
    }

    public OpenApi3 setInfo(Info info) {
        this.info = info;
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public OpenApi3 setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public boolean hasServers() {
        return this.servers != null;
    }

    public OpenApi3 addServer(Server server) {
        this.servers = this.listAdd(this.servers, server);
        return this;
    }

    public OpenApi3 removeServer(Server server) {
        this.listRemove(this.servers, server);
        return this;
    }

    public Map<String, Path> getPaths() {
        return this.paths;
    }

    public OpenApi3 setPaths(Map<String, Path> paths) {
        this.paths = paths;
        return this;
    }

    public boolean hasPath(String name) {
        return this.mapHas(this.paths, name);
    }

    public Path getPath(String name) {
        return this.mapGet(this.paths, name);
    }

    public OpenApi3 setPath(String name, Path path) {
        if (this.paths == null) {
            this.paths = new HashMap<String, Path>();
        }
        this.paths.put(name, path);
        return this;
    }

    public OpenApi3 removePath(String name) {
        this.mapRemove(this.paths, name);
        return this;
    }

    public Components getComponents() {
        return this.components;
    }

    public OpenApi3 setComponents(Components components) {
        this.components = components;
        return this;
    }

    public SecurityRequirement getSecurity() {
        return this.security;
    }

    public OpenApi3 setSecurity(SecurityRequirement security) {
        this.security = security;
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public OpenApi3 setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public boolean hasTags() {
        return this.tags != null;
    }

    public OpenApi3 addTag(Tag tag) {
        this.tags = this.listAdd(this.tags, tag);
        return this;
    }

    public OpenApi3 insertTag(int index, Tag tag) {
        this.tags = this.listAdd(this.tags, index, tag);
        return this;
    }

    public OpenApi3 removeTag(Tag tag) {
        this.listRemove(this.tags, tag);
        return this;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public OpenApi3 setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public OAIContext getContext() {
        return this.context;
    }

    public void setContext(OAIContext context) {
        this.context = context;
    }

    public JsonNode getReferenceContent(String refString) {
        if (this.context == null) {
            return null;
        }
        Reference reference = this.context.getReferenceRegistry().getRef(refString);
        if (reference != null) {
            return reference.getContent();
        }
        return null;
    }

    public Operation getOperationById(String operationId) {
        if (this.paths == null) {
            return null;
        }
        for (Path path : this.paths.values()) {
            if (path.getOperations() == null) continue;
            for (Operation operation : path.getOperations().values()) {
                if (!operationId.equals(operation.getOperationId())) continue;
                return operation;
            }
        }
        return null;
    }

    public String getPathFrom(Path specPath) {
        if (this.paths == null) {
            return null;
        }
        for (Map.Entry<String, Path> path : this.paths.entrySet()) {
            if (!path.getValue().equals(specPath)) continue;
            return path.getKey();
        }
        return null;
    }

    public Path getPathItemByOperationId(String operationId) {
        if (this.paths == null) {
            return null;
        }
        for (Path path : this.paths.values()) {
            if (path.getOperations() == null) continue;
            for (Operation operation : path.getOperations().values()) {
                if (!operationId.equals(operation.getOperationId())) continue;
                return path;
            }
        }
        return null;
    }

    @Override
    public OpenApi3 copy(OAIContext context, boolean followRefs) {
        OpenApi3 copy = new OpenApi3();
        copy.setOpenapi(this.getOpenapi());
        copy.setInfo(this.copyField(this.getInfo(), context, followRefs));
        copy.setServers(this.copyList(this.getServers(), context, followRefs));
        copy.setTags(this.copyList(this.getTags(), context, followRefs));
        copy.setPaths(this.copyMap(this.getPaths(), context, followRefs));
        copy.setComponents(this.copyField(this.getComponents(), context, followRefs));
        copy.setExternalDocs(this.copyField(this.getExternalDocs(), context, followRefs));
        copy.setSecurity(this.copyField(this.getSecurity(), context, followRefs));
        copy.setExtensions(this.copyMap(this.getExtensions()));
        copy.setContext(context);
        return copy;
    }
}

