/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3.bind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import org.openapi4j.parser.model.v3.Schema;

public class SchemaSerializer
extends StdSerializer<Schema> {
    protected SchemaSerializer() {
        this(Schema.class);
    }

    protected SchemaSerializer(Class<Schema> t) {
        super(t);
    }

    public void serialize(Schema schema, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        if (schema.isRef()) {
            this.addStringField(gen, "$ref", schema.getRef());
            this.addStringField(gen, "description", schema.getDescription());
        } else {
            this.addStringField(gen, "title", schema.getTitle());
            this.addNumberField(gen, "multipleOf", schema.getMultipleOf());
            this.addNumberField(gen, "maximum", schema.getMaximum());
            this.addBooleanField(gen, "exclusiveMaximum", schema.getExclusiveMaximum());
            this.addNumberField(gen, "minimum", schema.getMinimum());
            this.addBooleanField(gen, "exclusiveMinimum", schema.getExclusiveMinimum());
            this.addNumberField(gen, "maxLength", schema.getMaxLength());
            this.addNumberField(gen, "minLength", schema.getMinLength());
            this.addStringField(gen, "pattern", schema.getPattern());
            this.addNumberField(gen, "maxItems", schema.getMaxItems());
            this.addNumberField(gen, "minItems", schema.getMinItems());
            this.addBooleanField(gen, "uniqueItems", schema.getUniqueItems());
            this.addNumberField(gen, "maxProperties", schema.getMaxProperties());
            this.addNumberField(gen, "minProperties", schema.getMinProperties());
            this.addStringCollection(gen, "required", schema.getRequiredFields());
            this.addStringCollection(gen, "enum", schema.getEnums());
            this.addStringField(gen, "type", schema.getType());
            this.addSchemaCollection(gen, "allOf", schema.getAllOfSchemas());
            this.addSchemaCollection(gen, "oneOf", schema.getOneOfSchemas());
            this.addSchemaCollection(gen, "anyOf", schema.getAnyOfSchemas());
            this.addObjectField(gen, "not", schema.getNotSchema());
            this.addObjectField(gen, "items", schema.getItemsSchema());
            this.addMapField(gen, "properties", schema.getProperties());
            if (schema.getAdditionalProperties() != null) {
                gen.writeObjectField("additionalProperties", (Object)schema.getAdditionalProperties());
            } else if (schema.getAdditionalPropertiesAllowed() != null) {
                gen.writeBooleanField("additionalProperties", schema.getAdditionalPropertiesAllowed().booleanValue());
            }
            this.addStringField(gen, "description", schema.getDescription());
            this.addStringField(gen, "format", schema.getFormat());
            this.addObjectField(gen, "default", schema.getDefault());
            this.addBooleanField(gen, "nullable", schema.getNullable());
            this.addObjectField(gen, "discriminator", schema.getDiscriminator());
            this.addBooleanField(gen, "readOnly", schema.getReadOnly());
            this.addBooleanField(gen, "writeOnly", schema.getWriteOnly());
            this.addObjectField(gen, "xml", schema.getXml());
            this.addObjectField(gen, "externalDocs", schema.getExternalDocs());
            this.addObjectField(gen, "example", schema.getExample());
            this.addBooleanField(gen, "deprecated", schema.getDeprecated());
            if (schema.getExtensions() != null) {
                for (Map.Entry<String, Object> entry : schema.getExtensions().entrySet()) {
                    gen.writeObjectField(entry.getKey(), entry.getValue());
                }
            }
        }
        gen.writeEndObject();
    }

    private void addBooleanField(JsonGenerator gen, String fieldName, Boolean value) throws IOException {
        if (value != null) {
            gen.writeBooleanField(fieldName, value.booleanValue());
        }
    }

    private void addObjectField(JsonGenerator gen, String fieldName, Object value) throws IOException {
        if (value != null) {
            gen.writeObjectField(fieldName, value);
        }
    }

    private void addStringField(JsonGenerator gen, String fieldName, String value) throws IOException {
        if (value != null) {
            gen.writeStringField(fieldName, value);
        }
    }

    private void addMapField(JsonGenerator gen, String fieldName, Map<String, Schema> value) throws IOException {
        if (value != null) {
            gen.writeObjectFieldStart(fieldName);
            for (Map.Entry<String, Schema> entry : value.entrySet()) {
                gen.writeObjectField(entry.getKey(), (Object)entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    private void addNumberField(JsonGenerator gen, String fieldName, Number value) throws IOException {
        if (value != null) {
            if (value instanceof Integer) {
                gen.writeNumberField(fieldName, ((Integer)value).intValue());
            } else if (value instanceof Long) {
                gen.writeNumberField(fieldName, ((Long)value).longValue());
            } else if (value instanceof Float) {
                gen.writeNumberField(fieldName, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                gen.writeNumberField(fieldName, ((Double)value).doubleValue());
            } else if (value instanceof BigDecimal) {
                gen.writeNumberField(fieldName, (BigDecimal)value);
            }
        }
    }

    private void addStringCollection(JsonGenerator gen, String fieldName, Collection<String> collection) throws IOException {
        if (collection != null) {
            gen.writeArrayFieldStart(fieldName);
            for (String value : collection) {
                gen.writeString(value);
            }
            gen.writeEndArray();
        }
    }

    private void addSchemaCollection(JsonGenerator gen, String fieldName, Collection<Schema> collection) throws IOException {
        if (collection != null) {
            gen.writeArrayFieldStart(fieldName);
            for (Schema value : collection) {
                gen.writeObject((Object)value);
            }
            gen.writeEndArray();
        }
    }
}

