/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Callback;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.validation.v3.ExpressionValidator;
import org.openapi4j.parser.validation.v3.PathValidator;
import org.openapi4j.parser.validation.v3.Regexes;

class CallbackValidator
extends ExpressionValidator<Callback> {
    private static final String PARAM_NOT_FOUND_ERR_MSG = "Parameter with path '%s' not found on operation.";
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{(.*?)}");
    private static final CallbackValidator INSTANCE = new CallbackValidator();

    private CallbackValidator() {
    }

    public static CallbackValidator instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Callback callback, ValidationResults results) {
        if (callback.isRef()) {
            this.validateReference(api, callback.getRef(), results, "$ref", CallbackValidator.instance(), Callback.class);
        } else {
            this.validateMap(api, callback.getCallbackPaths(), results, false, null, Regexes.NOEXT_REGEX, PathValidator.instance());
            this.validateMap(api, callback.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        }
    }

    void validateWithOperation(OpenApi3 api, Operation operation, String expression, ValidationResults results) {
        Matcher matcher = PATTERN_PARAM.matcher(expression);
        while (matcher.find()) {
            if (this.checkRequestParameter(api, operation, matcher.group(1), results) || this.checkResponseParameter(api, operation, matcher.group(1), results)) continue;
            results.addError(String.format(PARAM_NOT_FOUND_ERR_MSG, matcher.group(1)));
        }
    }
}

