/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Map;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Discriminator;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class DiscriminatorValidator
extends Validator3Base<OpenApi3, Discriminator> {
    private static final String UNKNOWN_SCHEMA_REF = "Unknown schema reference '%s'";
    private static final String UNKNOWN_SCHEMA_NAME = "Unknown schema name '%s'";
    private static final Validator<OpenApi3, Discriminator> INSTANCE = new DiscriminatorValidator();

    private DiscriminatorValidator() {
    }

    public static Validator<OpenApi3, Discriminator> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Discriminator discriminator, ValidationResults results) {
        Map<String, String> mapping = discriminator.getMapping();
        if (mapping != null) {
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                String ref = entry.getValue();
                if (ref.contains("/")) {
                    if (api.getContext().getReferenceRegistry().getRef(ref) != null) continue;
                    results.addError(String.format(UNKNOWN_SCHEMA_REF, ref), "mapping");
                    continue;
                }
                if (api.getComponents() != null && api.getComponents().hasSchema(ref)) continue;
                results.addError(String.format(UNKNOWN_SCHEMA_NAME, ref), "mapping");
            }
        }
        this.validateString(discriminator.getPropertyName(), results, true, "propertyName");
    }
}

