/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.RequestBody;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.validation.v3.Validator3Base;

abstract class ExpressionValidator<M>
extends Validator3Base<OpenApi3, M> {
    private static final String PARAM_NOT_FOUND_ERR_MSG = "Parameter '%s' not found in operation.";
    private static final String PARAM_PATH_EXCEPTION_ERR_MSG = "Path '%s' is malformed.\n'%s'";
    private static final Pattern PATTERN_REQUEST_PARAM = Pattern.compile("^(\\$request)(?:\\.)(query(?=\\.)|path(?=\\.)|header(?=\\.)|body(?=#/))(?:\\.|#/)(.+)");
    private static final Pattern PATTERN_RESPONSE_PARAM = Pattern.compile("^(\\$response)(?:\\.)(header(?=\\.)|body(?=#/))(?:\\.|#/)(.+)");

    ExpressionValidator() {
    }

    boolean checkRequestParameter(OpenApi3 api, Operation operation, String propValue, ValidationResults results) {
        Matcher matcher = PATTERN_REQUEST_PARAM.matcher(propValue);
        boolean matches = matcher.matches();
        if (matches) {
            if (matcher.group(2).equals("body")) {
                RequestBody reqBody = operation.getRequestBody();
                if (reqBody != null && this.hasBodyProperty(api, matcher.group(3), reqBody.getContentMediaTypes(), results)) {
                    return true;
                }
                results.addError(String.format(PARAM_NOT_FOUND_ERR_MSG, propValue));
            } else if (this.checkParameterIn(matcher.group(2), matcher.group(3), operation, results)) {
                return true;
            }
        }
        return matches;
    }

    boolean checkResponseParameter(OpenApi3 api, Operation operation, String propValue, ValidationResults results) {
        Matcher matcher = PATTERN_RESPONSE_PARAM.matcher(propValue);
        boolean matches = matcher.matches();
        if (matches) {
            if (matcher.group(2).equals("body")) {
                for (Response response : operation.getResponses().values()) {
                    if (!this.hasBodyProperty(api, matcher.group(3), response.getContentMediaTypes(), results)) continue;
                    return true;
                }
                results.addError(String.format(PARAM_NOT_FOUND_ERR_MSG, propValue));
            } else if (this.checkParameterIn(matcher.group(2), matcher.group(3), operation, results)) {
                return true;
            }
        }
        return matches;
    }

    private boolean hasBodyProperty(OpenApi3 api, String propValue, Map<String, MediaType> contentMediaTypes, ValidationResults results) {
        String[] pathFragments = propValue.split("/");
        for (Map.Entry<String, MediaType> entry : contentMediaTypes.entrySet()) {
            try {
                if (!this.hasBodyProperty(api, entry.getValue().getSchema(), pathFragments, 0)) continue;
                return true;
            }
            catch (DecodeException e) {
                results.addError(String.format(PARAM_PATH_EXCEPTION_ERR_MSG, propValue, e.getMessage()));
            }
        }
        return false;
    }

    private boolean hasBodyProperty(OpenApi3 api, Schema schema, String[] pathFragments, int index) throws DecodeException {
        if (schema == null) {
            return false;
        }
        if (pathFragments.length > index) {
            if (schema.isRef()) {
                schema = (Schema)api.getContext().getReferenceRegistry().getRef(schema.getRef()).getMappedContent(Schema.class);
            }
            if ("array".equals(schema.getType())) {
                return this.hasBodyProperty(api, schema.getItemsSchema(), pathFragments, index);
            }
            Schema subSchema = schema.getProperty(pathFragments[index]);
            if (subSchema == null) {
                return false;
            }
            return pathFragments.length == ++index || this.hasBodyProperty(api, subSchema, pathFragments, index);
        }
        return false;
    }

    private boolean checkParameterIn(String in, String propName, Operation operation, ValidationResults results) {
        for (Parameter param : operation.getParametersIn(in)) {
            if (!param.getName().equals(propName)) continue;
            return true;
        }
        results.addError(String.format(PARAM_NOT_FOUND_ERR_MSG, propName));
        return false;
    }
}

