/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.Info;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.ContactValidator;
import org.openapi4j.parser.validation.v3.LicenseValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class InfoValidator
extends Validator3Base<OpenApi3, Info> {
    private static final Validator<OpenApi3, Info> INSTANCE = new InfoValidator();

    private InfoValidator() {
    }

    public static Validator<OpenApi3, Info> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Info info, ValidationResults results) {
        this.validateField(api, info.getContact(), results, false, "contact", ContactValidator.instance());
        this.validateMap(api, info.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        this.validateField(api, info.getLicense(), results, false, "license", LicenseValidator.instance());
        this.validateUrl(info.getTermsOfService(), results, false, "termsOfService", ValidationSeverity.WARNING);
        this.validateString(info.getTitle(), results, true, "title");
        this.validateString(info.getVersion(), results, true, "version");
    }
}

