/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Map;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Link;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.validation.v3.ExpressionValidator;
import org.openapi4j.parser.validation.v3.HeaderValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.ServerValidator;

class LinkValidator
extends ExpressionValidator<Link> {
    private static final String OP_FIELD_MISSING_ERR_MSG = "'operationRef', 'operationId' or '$ref' field missing.";
    private static final String OP_FIELD_EXCLUSIVE_ERR_MSG = "'operationRef' and 'operationId' fields are mutually exclusives.";
    private static final String OP_NOT_FOUND_ERR_MSG = "'%s' not found.";
    private static final String PARAM_PATH_ERR_MSG = "Path '%s' on parameter '%s' is malformed.";
    private static final String PARAM_NOT_FOUND_ERR_MSG = "Parameter name '%s' not found in target operation.";
    private static final String REF_CONTENT_UNREADABLE = "Unable to read $ref content at '%s'.";
    private static final LinkValidator INSTANCE = new LinkValidator();

    private LinkValidator() {
    }

    public static LinkValidator instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Link link, ValidationResults results) {
        if (link.isRef()) {
            this.validateReference(api, link.getRef(), results, "links", LinkValidator.instance(), Link.class);
        } else {
            this.validateMap(api, link.getHeaders(), results, false, "headers", Regexes.NOEXT_REGEX, HeaderValidator.instance());
            this.validateMap(api, link.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
            this.validateField(api, link.getServer(), results, false, "server", ServerValidator.instance());
        }
    }

    void validateWithOperation(OpenApi3 api, Operation srcOperation, Link link, ValidationResults results) {
        if (link.isRef()) {
            try {
                link = (Link)api.getContext().getReferenceRegistry().getRef(link.getRef()).getMappedContent(Link.class);
            }
            catch (DecodeException e) {
                results.addError(String.format(REF_CONTENT_UNREADABLE, link.getRef()), "links");
                return;
            }
        }
        String operationRef = link.getOperationRef();
        String operationId = link.getOperationId();
        Operation targetOperation = null;
        if (operationId != null && operationRef != null) {
            results.addError(OP_FIELD_EXCLUSIVE_ERR_MSG);
        } else if (operationRef != null) {
            targetOperation = this.findOperationByPath(api, operationRef, results);
        } else if (operationId != null) {
            targetOperation = this.findOperationById(api, operationId, results);
        } else {
            results.addError(OP_FIELD_MISSING_ERR_MSG);
        }
        if (targetOperation != null) {
            this.checkSourceOperationParameters(api, srcOperation, link, results);
            this.checkTargetOperationParameters(targetOperation, link, results);
        }
    }

    private Operation findOperationById(OpenApi3 api, String operationId, ValidationResults results) {
        for (Path path : api.getPaths().values()) {
            for (Operation op : path.getOperations().values()) {
                if (!operationId.equals(op.getOperationId())) continue;
                return op;
            }
        }
        results.addError(String.format(OP_NOT_FOUND_ERR_MSG, operationId), "operationId");
        return null;
    }

    private Operation findOperationByPath(OpenApi3 api, String operationRef, ValidationResults results) {
        Reference reference = api.getContext().getReferenceRegistry().getRef(operationRef);
        if (reference != null) {
            try {
                return (Operation)reference.getMappedContent(Operation.class);
            }
            catch (DecodeException e) {
                results.addError(e.getMessage(), "operationRef");
            }
        }
        results.addError(String.format(OP_NOT_FOUND_ERR_MSG, operationRef), "operationRef");
        return null;
    }

    private void checkSourceOperationParameters(OpenApi3 api, Operation operation, Link link, ValidationResults results) {
        for (Map.Entry<String, String> entry : link.getParameters().entrySet()) {
            if (this.checkRequestParameter(api, operation, entry.getValue(), results) || this.checkResponseParameter(api, operation, entry.getValue(), results)) continue;
            results.addError(String.format(PARAM_PATH_ERR_MSG, entry.getValue(), entry.getKey()));
        }
    }

    private void checkTargetOperationParameters(Operation operation, Link link, ValidationResults results) {
        for (String paramName : link.getParameters().keySet()) {
            boolean hasParameter = false;
            for (Parameter param : operation.getParameters()) {
                if (!"path".equals(param.getIn()) && !"query".equals(param.getIn()) || !paramName.equals(param.getName())) continue;
                hasParameter = true;
                break;
            }
            if (hasParameter) continue;
            results.addError(String.format(PARAM_NOT_FOUND_ERR_MSG, paramName));
        }
    }
}

